/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.resource.ClassloaderClasspathUriResolver;
import org.eclipse.xtext.resource.XtextResourceSet;

public abstract class BaseEPackageAccess {
    public static EPackage getEPackageFromRegistry(String string) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string);
        if (ePackage == null) {
            throw new IllegalStateException("couldn't load EPackage for URI '" + string + "'");
        }
        return ePackage;
    }

    public static EPackage loadEcoreFile(ClassLoader loader, String string) {
        URI uri = URI.createURI((String)string);
        if (!uri.hasFragment()) {
            uri = uri.appendFragment("/");
        }
        URI normalized = new ClassloaderClasspathUriResolver().resolve(loader, uri);
        return (EPackage)new ResourceSetImpl().getEObject(normalized, true);
    }

    public static Object loadGrammarFile(String string, XtextResourceSet resourceSet) {
        Resource resource = BaseEPackageAccess.loadResource(string, resourceSet);
        return resource.getContents().get(0);
    }

    public static Resource loadResource(String string, XtextResourceSet resourceSet) {
        Resource resource;
        URI uri = URI.createURI((String)string);
        try {
            resource = resourceSet.getResource(uri, true);
            if (resource == null) {
                throw new IllegalArgumentException("Couldn't create resource for URI : " + String.valueOf(uri));
            }
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        EList contents = resource.getContents();
        if (contents.size() < 1) {
            throw new IllegalStateException("loading classpath:" + string + " : Expected at least root element but found " + contents.size());
        }
        return resource;
    }
}

