/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.notifications.feed.ServiceMessageEvent;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.commons.notifications.feed.ServiceMessage;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListServiceMessageControl;
import org.eclipse.swt.widgets.Composite;

public class TaskListServiceMessageControlTest
extends TestCase {
    protected void setUp() throws Exception {
        TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.servicemessage.id", "");
    }

    public void testGetAction() {
        TaskListServiceMessageControlTest.assertEquals((String)"abc", (String)TaskListServiceMessageControl.getAction((String)"ABC"));
        TaskListServiceMessageControlTest.assertEquals((String)"abc", (String)TaskListServiceMessageControl.getAction((String)"abc"));
        TaskListServiceMessageControlTest.assertEquals((String)"def", (String)TaskListServiceMessageControl.getAction((String)"http://eclipse.org?action=DEF"));
        TaskListServiceMessageControlTest.assertEquals((String)"defg", (String)TaskListServiceMessageControl.getAction((String)"http://eclipse.org?action=defg&foo=bar"));
        TaskListServiceMessageControlTest.assertEquals(null, (String)TaskListServiceMessageControl.getAction((String)"http://eclipse.org?foo=bar&action=defg"));
    }

    public void testCloseMessageWithNoId() {
        TestTaskListServiceMessageControl control = new TestTaskListServiceMessageControl((Composite)WorkbenchUtil.getShell());
        control.setMessage(new ServiceMessage("123"));
        control.closeMessage();
        TaskListServiceMessageControlTest.assertEquals((String)"", (String)this.getLastMessageId());
    }

    public void testCloseMessageWithId() {
        TestTaskListServiceMessageControl control = new TestTaskListServiceMessageControl((Composite)WorkbenchUtil.getShell());
        ServiceMessage message = new ServiceMessage("123");
        message.setId("300");
        control.setMessage(message);
        control.closeMessage();
        TaskListServiceMessageControlTest.assertEquals((String)"300", (String)this.getLastMessageId());
    }

    public void testHandleEvent() throws Exception {
        TestTaskListServiceMessageControl control = new TestTaskListServiceMessageControl((Composite)WorkbenchUtil.getShell());
        this.handleMessage(control, "123");
        control.closeMessage();
        TaskListServiceMessageControlTest.assertEquals((String)"123", (String)this.getLastMessageId());
        this.handleMessage(control, "100");
        control.closeMessage();
        TaskListServiceMessageControlTest.assertEquals((String)"123", (String)this.getLastMessageId());
        this.handleMessage(control, "200");
        control.closeMessage();
        TaskListServiceMessageControlTest.assertEquals((String)"200", (String)this.getLastMessageId());
        this.handleMessage(control, "org.eclipse.mylyn.reset.1");
        control.closeMessage();
        TaskListServiceMessageControlTest.assertEquals((String)"", (String)this.getLastMessageId());
        this.handleMessage(control, "hello");
        control.closeMessage();
        TaskListServiceMessageControlTest.assertEquals((String)"hello", (String)this.getLastMessageId());
    }

    private String getLastMessageId() {
        return TasksUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.tasks.ui.servicemessage.id");
    }

    private void handleMessage(TestTaskListServiceMessageControl control, String id) {
        ServiceMessage message = new ServiceMessage("123");
        message.setTitle("Title");
        message.setDescription("Description");
        message.setImage("dialog_help_image");
        message.setId(id);
        control.handleEvent(new ServiceMessageEvent(TasksUiPlugin.getDefault().getServiceMessageManager(), ServiceMessageEvent.Kind.MESSAGE_UPDATE, List.of(message)));
    }

    private final class TestTaskListServiceMessageControl
    extends TaskListServiceMessageControl {
        private TestTaskListServiceMessageControl(Composite parent) {
            super(parent);
        }

        protected void closeMessage() {
            super.closeMessage();
        }
    }
}

