/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.client.impl;

import com.google.gwt.requestfactory.shared.EntityProxy;
import com.google.gwt.requestfactory.shared.EntityProxyId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleEntityProxyId<P extends EntityProxy>
implements EntityProxyId<P> {
    private static final int NEVER_EPHEMERAL = -1;
    private final int clientId;
    private final int hashCode;
    private final Class<P> proxyClass;
    private String serverId;

    SimpleEntityProxyId(Class<P> proxyClass, String serverId) {
        this.setServerId(serverId);
        this.clientId = -1;
        this.hashCode = serverId.hashCode();
        this.proxyClass = proxyClass;
    }

    SimpleEntityProxyId(Class<P> proxyClass, int clientId) {
        this.clientId = clientId;
        this.proxyClass = proxyClass;
        this.hashCode = clientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleEntityProxyId)) {
            return false;
        }
        SimpleEntityProxyId other = (SimpleEntityProxyId)o;
        if (!this.proxyClass.equals(other.proxyClass)) {
            return false;
        }
        if (this.clientId != -1 && this.clientId == other.clientId) {
            return true;
        }
        return this.serverId != null && this.serverId.equals(other.serverId);
    }

    public int getClientId() {
        return this.clientId;
    }

    @Override
    public Class<P> getProxyClass() {
        return this.proxyClass;
    }

    public String getServerId() {
        return this.serverId;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isEphemeral() {
        return this.serverId == null;
    }

    public void setServerId(String serverId) {
        if (this.serverId != null) {
            throw new IllegalStateException();
        }
        this.serverId = serverId;
    }
}

