/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.ui.client.adapters.HasTextEditor;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.HasAllMouseHandlers;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasDoubleClickHandlers;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.BidiUtils;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.shared.BidiFormatter;
import com.google.gwt.i18n.shared.DirectionEstimator;
import com.google.gwt.i18n.shared.HasDirectionEstimator;
import com.google.gwt.i18n.shared.WordCountDirectionEstimator;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HasAutoHorizontalAlignment;
import com.google.gwt.user.client.ui.HasDirectionalText;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasWordWrap;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseWheelListener;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesMouseEvents;
import com.google.gwt.user.client.ui.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Label
extends Widget
implements HasDirectionalText,
HasWordWrap,
HasDirection,
HasClickHandlers,
HasDoubleClickHandlers,
SourcesClickEvents,
SourcesMouseEvents,
HasAllMouseHandlers,
HasDirectionEstimator,
HasAutoHorizontalAlignment,
IsEditor<LeafValueEditor<String>> {
    private HasHorizontalAlignment.AutoHorizontalAlignmentConstant autoHorizontalAlignment;
    private HasDirection.Direction textDir;
    private DirectionEstimator directionEstimator;
    private HasHorizontalAlignment.HorizontalAlignmentConstant horzAlign;
    private HasDirection.Direction initialElementDir;
    private boolean isElementInline;
    private boolean isSpanWrapped;

    public static Label wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        Label label = new Label(element);
        label.onAttach();
        RootPanel.detachOnWindowClose(label);
        return label;
    }

    public Label() {
        this.setElement(Document.get().createDivElement());
        this.setStyleName("gwt-Label");
        this.isElementInline = false;
        this.isSpanWrapped = false;
        this.textDir = HasDirection.Direction.DEFAULT;
        this.initialElementDir = HasDirection.Direction.DEFAULT;
    }

    public Label(String text) {
        this();
        this.setText(text);
    }

    public Label(String text, HasDirection.Direction dir) {
        this();
        this.setText(text, dir);
    }

    public Label(String text, boolean wordWrap) {
        this(text);
        this.setWordWrap(wordWrap);
    }

    protected Label(Element element) {
        this.setElement(element);
        String tagName = element.getTagName();
        this.isElementInline = tagName.equalsIgnoreCase("span");
        assert (this.isElementInline || tagName.equalsIgnoreCase("div"));
        this.isSpanWrapped = false;
        this.textDir = this.initialElementDir = BidiUtils.getDirectionOnElement(element);
    }

    @Override
    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addDomHandler(handler, ClickEvent.getType());
    }

    @Override
    @Deprecated
    public void addClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener.add(this, listener);
    }

    @Override
    public HandlerRegistration addDoubleClickHandler(DoubleClickHandler handler) {
        return this.addDomHandler(handler, DoubleClickEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.addDomHandler(handler, MouseDownEvent.getType());
    }

    @Override
    @Deprecated
    public void addMouseListener(MouseListener listener) {
        ListenerWrapper.WrappedMouseListener.add(this, listener);
    }

    @Override
    public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
        return this.addDomHandler(handler, MouseMoveEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
        return this.addDomHandler(handler, MouseOutEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
        return this.addDomHandler(handler, MouseOverEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
        return this.addDomHandler(handler, MouseUpEvent.getType());
    }

    @Override
    public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
        return this.addDomHandler(handler, MouseWheelEvent.getType());
    }

    @Deprecated
    public void addMouseWheelListener(MouseWheelListener listener) {
        ListenerWrapper.WrappedMouseWheelListener.add(this, listener);
    }

    @Override
    public LeafValueEditor<String> asEditor() {
        return HasTextEditor.of(this);
    }

    @Override
    public HasHorizontalAlignment.AutoHorizontalAlignmentConstant getAutoHorizontalAlignment() {
        return this.autoHorizontalAlignment;
    }

    @Override
    @Deprecated
    public HasDirection.Direction getDirection() {
        return BidiUtils.getDirectionOnElement(this.getElement());
    }

    @Override
    public DirectionEstimator getDirectionEstimator() {
        return this.directionEstimator;
    }

    @Override
    public HasHorizontalAlignment.HorizontalAlignmentConstant getHorizontalAlignment() {
        return this.horzAlign;
    }

    @Override
    public String getText() {
        return this.getTextOrHtml(false);
    }

    @Override
    public HasDirection.Direction getTextDirection() {
        return this.textDir;
    }

    @Override
    public boolean getWordWrap() {
        return !this.getElement().getStyle().getProperty("whiteSpace").equals("nowrap");
    }

    @Override
    @Deprecated
    public void removeClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener.remove(this, listener);
    }

    @Override
    @Deprecated
    public void removeMouseListener(MouseListener listener) {
        ListenerWrapper.WrappedMouseListener.remove(this, listener);
    }

    @Deprecated
    public void removeMouseWheelListener(MouseWheelListener listener) {
        ListenerWrapper.WrappedMouseWheelListener.remove(this, listener);
    }

    @Override
    public void setAutoHorizontalAlignment(HasHorizontalAlignment.AutoHorizontalAlignmentConstant autoAlignment) {
        this.autoHorizontalAlignment = autoAlignment;
        this.updateHorizontalAlignment();
    }

    @Override
    @Deprecated
    public void setDirection(HasDirection.Direction direction) {
        BidiUtils.setDirectionOnElement(this.getElement(), direction);
        this.initialElementDir = direction;
        this.setInnerTextOrHtml(this.getTextOrHtml(true), true);
        this.isSpanWrapped = false;
        this.textDir = this.initialElementDir;
        this.updateHorizontalAlignment();
    }

    @Override
    public void setDirectionEstimator(boolean enabled) {
        this.setDirectionEstimator(enabled ? WordCountDirectionEstimator.get() : null);
    }

    @Override
    public void setDirectionEstimator(DirectionEstimator directionEstimator) {
        this.directionEstimator = directionEstimator;
        this.setTextOrHtml(this.getTextOrHtml(true), true);
    }

    @Override
    public void setHorizontalAlignment(HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        this.setAutoHorizontalAlignment(align);
    }

    @Override
    public void setText(String text) {
        this.setTextOrHtml(text, false);
    }

    @Override
    public void setText(String text, HasDirection.Direction dir) {
        this.setTextOrHtml(text, dir, false);
    }

    @Override
    public void setWordWrap(boolean wrap) {
        this.getElement().getStyle().setProperty("whiteSpace", wrap ? "normal" : "nowrap");
    }

    protected String getTextOrHtml(boolean isHtml) {
        Element element = this.isSpanWrapped ? this.getElement().getFirstChildElement() : this.getElement();
        return isHtml ? element.getInnerHTML() : element.getInnerText();
    }

    protected void setHTML(SafeHtml html) {
        this.setTextOrHtml(html.asString(), true);
    }

    protected void setHTML(SafeHtml html, HasDirection.Direction dir) {
        this.setTextOrHtml(html.asString(), dir, true);
    }

    protected void setTextOrHtml(String content, boolean isHtml) {
        if (this.directionEstimator == null) {
            this.isSpanWrapped = false;
            this.setInnerTextOrHtml(content, isHtml);
            if (this.textDir != this.initialElementDir) {
                this.textDir = this.initialElementDir;
                BidiUtils.setDirectionOnElement(this.getElement(), this.initialElementDir);
                this.updateHorizontalAlignment();
            }
        } else {
            this.setTextOrHtml(content, this.directionEstimator.estimateDirection(content, isHtml), isHtml);
        }
    }

    protected void setTextOrHtml(String content, HasDirection.Direction dir, boolean isHtml) {
        this.textDir = dir;
        if (this.isElementInline) {
            this.isSpanWrapped = true;
            this.getElement().setInnerHTML(BidiFormatter.getInstanceForCurrentLocale(true).spanWrapWithKnownDir(dir, content, isHtml));
        } else {
            this.isSpanWrapped = false;
            BidiUtils.setDirectionOnElement(this.getElement(), dir);
            this.setInnerTextOrHtml(content, isHtml);
        }
        this.updateHorizontalAlignment();
    }

    private void setInnerTextOrHtml(String content, boolean isHtml) {
        if (isHtml) {
            this.getElement().setInnerHTML(content);
        } else {
            this.getElement().setInnerText(content);
        }
    }

    private void updateHorizontalAlignment() {
        HasHorizontalAlignment.HorizontalAlignmentConstant align;
        if (this.autoHorizontalAlignment == null) {
            align = null;
        } else if (this.autoHorizontalAlignment instanceof HasHorizontalAlignment.HorizontalAlignmentConstant) {
            align = (HasHorizontalAlignment.HorizontalAlignmentConstant)this.autoHorizontalAlignment;
        } else {
            HasHorizontalAlignment.HorizontalAlignmentConstant horizontalAlignmentConstant = align = this.autoHorizontalAlignment == ALIGN_CONTENT_START ? HasHorizontalAlignment.HorizontalAlignmentConstant.startOf(this.textDir) : HasHorizontalAlignment.HorizontalAlignmentConstant.endOf(this.textDir);
        }
        if (align != this.horzAlign) {
            this.horzAlign = align;
            this.getElement().getStyle().setProperty("textAlign", this.horzAlign == null ? "" : this.horzAlign.getTextAlignString());
        }
    }
}

