/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common;

import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.Project;
import com.google.gwtorm.client.KeyUtil;

public class PageLinks {
    public static final String SETTINGS = "settings";
    public static final String SETTINGS_PREFERENCES = "settings,preferences";
    public static final String SETTINGS_SSHKEYS = "settings,ssh-keys";
    public static final String SETTINGS_HTTP_PASSWORD = "settings,http-password";
    public static final String SETTINGS_WEBIDENT = "settings,web-identities";
    public static final String SETTINGS_MYGROUPS = "settings,group-memberships";
    public static final String SETTINGS_AGREEMENTS = "settings,agreements";
    public static final String SETTINGS_CONTACT = "settings,contact";
    public static final String SETTINGS_PROJECTS = "settings,projects";
    public static final String SETTINGS_NEW_AGREEMENT = "settings,new-agreement";
    public static final String REGISTER = "register";
    public static final String TOP = "n,z";
    public static final String MINE = "mine";
    public static final String ADMIN_GROUPS = "admin,groups";
    public static final String ADMIN_PROJECTS = "admin,projects";

    public static String toChange(ChangeInfo c) {
        return PageLinks.toChange(c.getId());
    }

    public static String toChange(Change.Id c) {
        return "change," + c.toString();
    }

    public static String toAccountDashboard(AccountInfo acct) {
        return PageLinks.toAccountDashboard(acct.getId());
    }

    public static String toAccountDashboard(Account.Id acct) {
        return "dashboard," + acct.toString();
    }

    public static String toChangeQuery(String query) {
        return "q," + KeyUtil.encode((String)query) + "," + TOP;
    }

    public static String projectQuery(Project.NameKey proj, Change.Status status) {
        switch (status) {
            case ABANDONED: {
                return "status:abandoned " + PageLinks.op("project", proj.get());
            }
            case MERGED: {
                return "status:merged " + PageLinks.op("project", proj.get());
            }
        }
        return "status:open " + PageLinks.op("project", proj.get());
    }

    public static String op(String name, String value) {
        if (value.indexOf(32) >= 0) {
            return name + ":\"" + value + "\"";
        }
        return name + ":" + value;
    }

    protected PageLinks() {
    }
}

