/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.jdbc.gen.CodeGenSupport;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.schema.sql.SqlTypeInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.objectweb.asm.Type;

public class SqlByteArrayTypeInfo
extends SqlTypeInfo {
    @Override
    protected String getJavaSqlTypeAlias() {
        return "BinaryStream";
    }

    @Override
    protected int getSqlTypeConstant() {
        return -3;
    }

    @Override
    public String getSqlType(ColumnModel col, SqlDialect dialect) {
        StringBuilder r = new StringBuilder();
        r.append(dialect.getSqlTypeName(this.getSqlTypeConstant()));
        if (col.isNotNull()) {
            r.append(" DEFAULT ''");
            r.append(" NOT NULL");
        }
        return r.toString();
    }

    @Override
    public void generatePreparedStatementSet(CodeGenSupport cgs) {
        cgs.pushSqlHandle();
        cgs.pushColumnIndex();
        cgs.pushFieldValue();
        cgs.mv.visitMethodInsn(184, Type.getInternalName(SqlByteArrayTypeInfo.class), "toPreparedStatement", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PreparedStatement.class), Type.INT_TYPE, Type.getType(byte[].class)}));
    }

    @Override
    public void generateResultSetGet(CodeGenSupport cgs) {
        cgs.fieldSetBegin();
        cgs.pushSqlHandle();
        cgs.pushColumnIndex();
        cgs.mv.visitMethodInsn(184, Type.getInternalName(SqlByteArrayTypeInfo.class), "fromResultSet", Type.getMethodDescriptor((Type)Type.getType(byte[].class), (Type[])new Type[]{Type.getType(ResultSet.class), Type.INT_TYPE}));
        cgs.fieldSetEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fromResultSet(ResultSet rs, int col) throws SQLException {
        byte[] byArray;
        InputStream r = rs.getBinaryStream(col);
        if (r == null) {
            return null;
        }
        try {
            int n;
            ByteArrayOutputStream w = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((n = r.read(buf)) > 0) {
                w.write(buf, 0, n);
            }
            byArray = w.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                r.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new SQLException("Unable to read BinaryStream in column " + col);
            }
        }
        r.close();
        return byArray;
    }

    public static void toPreparedStatement(PreparedStatement ps, int col, byte[] raw) throws SQLException {
        if (raw != null) {
            ps.setBinaryStream(col, (InputStream)new ByteArrayInputStream(raw), raw.length);
        } else {
            ps.setNull(col, -3);
        }
    }
}

