/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.sdk.util;

import junit.framework.TestCase;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextManager;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public abstract class AbstractContextTest
extends TestCase {
    protected static final String MOCK_HANDLE = "<mock-handle>";
    private static final String MOCK_PROVIDER = "<mock-provider>";
    protected static final String MOCK_ORIGIN = "<mock-origin>";
    protected static final String MOCK_KIND = "java";

    protected void setUp() throws Exception {
        super.setUp();
        if (ContextCore.getContextManager() != null) {
            AbstractContextTest.assertFalse((String)("Unexpected context active: " + String.valueOf(((InteractionContextManager)ContextCore.getContextManager()).getActiveContexts())), (boolean)ContextCore.getContextManager().isContextActive());
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (ContextCore.getContextManager() != null) {
            AbstractContextTest.assertFalse((String)String.valueOf(((InteractionContextManager)ContextCore.getContextManager()).getActiveContexts()), (boolean)ContextCore.getContextManager().isContextActive());
        }
    }

    protected InteractionEvent mockSelection(String handle) {
        return new InteractionEvent(InteractionEvent.Kind.SELECTION, MOCK_KIND, handle, MOCK_ORIGIN);
    }

    protected InteractionEvent mockPropagation(String handle) {
        return new InteractionEvent(InteractionEvent.Kind.PROPAGATION, MOCK_KIND, handle, MOCK_ORIGIN);
    }

    protected InteractionEvent mockSelection() {
        return this.mockSelection(MOCK_HANDLE);
    }

    protected InteractionEvent mockNavigation(String toHandle) {
        return new InteractionEvent(InteractionEvent.Kind.SELECTION, MOCK_KIND, toHandle, MOCK_ORIGIN, MOCK_PROVIDER);
    }

    protected InteractionEvent mockInterestContribution(String handle, String kind, float value) {
        InteractionEvent event = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, kind, handle, MOCK_ORIGIN, value);
        return event;
    }

    protected InteractionEvent mockInterestContribution(String handle, float value) {
        return this.mockInterestContribution(handle, MOCK_KIND, value);
    }

    protected InteractionEvent mockPreferenceChange(String handle) {
        return new InteractionEvent(InteractionEvent.Kind.PREFERENCE, MOCK_KIND, handle, MOCK_ORIGIN);
    }

    protected boolean compareTaskscapeEquality(IInteractionContext t1, IInteractionContext t2) {
        return false;
    }
}

