/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.carousel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.carousel.Carousel;
import org.eclipse.nebula.widgets.carousel.ImageContainer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class ImageSelector
extends Canvas {
    private static final int CIRCLE_DIAMETER = 20;
    private static final int ARROW_SIZE = 12;
    Color arrowColor;
    Color circleBackground;
    Color circleForeground;
    Color circleHoverColor;
    private final List<Rectangle> rects = new ArrayList<Rectangle>();
    private int indexHover = -1;
    private Rectangle arrowLeftArea;
    private Rectangle arrowRightArea;
    private boolean hoverLeftArrow;
    private boolean hoverRightArrow;
    private final Carousel carousel;

    public ImageSelector(Carousel parent, int none) {
        super((Composite)parent, 0x20000000);
        this.carousel = parent;
        this.addListener(9, e -> {
            GC gc = e.gc;
            gc.setFont(this.getFont());
            gc.setAdvanced(true);
            gc.setTextAntialias(1);
            gc.setAntialias(1);
            Color previousForeground = gc.getForeground();
            Color previousBackground = gc.getBackground();
            this.drawContent(gc);
            gc.setBackground(previousBackground);
            gc.setForeground(previousForeground);
        });
        this.addListener(7, e -> {
            this.indexHover = -1;
            this.setCursor(this.getDisplay().getSystemCursor(0));
        });
        this.addListener(5, e -> {
            Point pt = this.getDisplay().getCursorLocation();
            pt = this.getDisplay().map(null, (Control)this, pt.x, pt.y);
            this.hoverLeftArrow = this.arrowLeftArea.contains(pt);
            this.hoverRightArrow = this.arrowRightArea.contains(pt);
            Cursor expectedCursor = this.hoverLeftArrow || this.hoverRightArrow ? this.getDisplay().getSystemCursor(21) : this.getDisplay().getSystemCursor(0);
            this.indexHover = -1;
            int i = 0;
            while (i < this.rects.size()) {
                Rectangle rect = this.rects.get(i);
                if (rect.contains(pt)) {
                    expectedCursor = this.getDisplay().getSystemCursor(21);
                    this.indexHover = i;
                    break;
                }
                ++i;
            }
            if (!expectedCursor.equals((Object)this.getCursor())) {
                this.setCursor(expectedCursor);
            }
            this.redraw();
        });
        this.addListener(4, e -> {
            ImageContainer imageContainer = carousel.imageContainer;
            if (this.hoverLeftArrow) {
                imageContainer.movePrevious();
            } else if (this.hoverRightArrow) {
                imageContainer.moveNext();
            } else if (this.indexHover != -1) {
                imageContainer.moveTo(this.indexHover);
            }
        });
    }

    private void drawContent(GC gc) {
        int x = this.drawCircles(gc);
        this.drawArrows(x, gc);
    }

    private int drawCircles(GC gc) {
        int x = 0;
        Rectangle clientArea = this.getClientArea();
        this.rects.clear();
        int i = 0;
        while (i < this.carousel.getImages().size()) {
            Rectangle rect = new Rectangle(x, (clientArea.height - 20) / 2, 20, 20);
            this.rects.add(rect);
            if (i == this.carousel.getSelection()) {
                gc.setBackground(this.circleBackground);
                gc.fillOval(rect.x, rect.y, 20, 20);
            } else if (i == this.indexHover) {
                gc.setForeground(this.circleHoverColor);
                gc.drawOval(rect.x, rect.y, 20, 20);
            } else {
                gc.setForeground(this.circleForeground);
                gc.drawOval(rect.x, rect.y, 20, 20);
            }
            x += 25;
            ++i;
        }
        return x + 20;
    }

    private void drawArrows(int x, GC gc) {
        gc.setForeground(this.arrowColor);
        Rectangle clientArea = this.getClientArea();
        int topY = (clientArea.height - 12) / 2;
        int width = 6;
        gc.setLineWidth(this.hoverLeftArrow ? 3 : 1);
        gc.drawPolyline(new int[]{x + 6, topY, x, topY + 6, x + 6, topY + 12});
        this.arrowLeftArea = new Rectangle(x, topY, 12, 12);
        gc.setLineWidth(this.hoverRightArrow ? 3 : 1);
        gc.drawPolyline(new int[]{x += 36, topY, x + 6, topY + 6, x, topY + 12});
        this.arrowRightArea = new Rectangle(x, topY, 12, 12);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point superSize = super.computeSize(wHint, hHint, changed);
        int width = 70 + this.carousel.getImages().size() * 25;
        int height = 40;
        return new Point(Math.max(superSize.x, width), Math.max(superSize.y, 40));
    }
}

