/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.calculator;

import org.eclipse.nebula.widgets.opal.calculator.CalculatorButtonsComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class CalculatorCombo
extends Composite {
    private Label label;
    private Button arrow;
    private Shell popup;
    private Listener listener;
    private Listener filter;
    private boolean hasFocus;
    private Listener keyListener;
    private CalculatorButtonsComposite composite;

    public CalculatorCombo(Composite parent, int style) {
        super(parent, style);
        int[] buttonEvents;
        int[] calculatorComboEvents;
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.label = new Label((Composite)this, 133120);
        this.label.setBackground(this.getDisplay().getSystemColor(25));
        this.label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.arrow = new Button((Composite)this, 1028);
        this.arrow.setLayoutData((Object)new GridData(4, 4, false, false));
        this.listener = event -> {
            if (this.popup == event.widget) {
                this.handlePopupEvent(event);
                return;
            }
            if (this.arrow == event.widget) {
                this.handleButtonEvent(event);
                return;
            }
            if (this == event.widget) {
                this.handleMultiChoiceEvent(event);
                return;
            }
            if (this.getShell() == event.widget) {
                this.getDisplay().asyncExec(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    this.handleFocusEvent(16);
                });
            }
        };
        int[] nArray = calculatorComboEvents = new int[]{12, 10, 11};
        int n = calculatorComboEvents.length;
        int n2 = 0;
        while (n2 < n) {
            int calculatorComboEvent = nArray[n2];
            this.addListener(calculatorComboEvent, this.listener);
            ++n2;
        }
        int[] nArray2 = buttonEvents = new int[]{13, 15};
        int n3 = buttonEvents.length;
        n = 0;
        while (n < n3) {
            int buttonEvent = nArray2[n];
            this.arrow.addListener(buttonEvent, this.listener);
            ++n;
        }
        this.filter = event -> {
            Shell shell = ((Control)event.widget).getShell();
            if (shell == this.getShell()) {
                this.handleFocusEvent(16);
            }
        };
        this.createPopupShell();
    }

    private void handlePopupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.popup.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width - 1, listRect.height - 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.hidePopupWindow(false);
                break;
            }
            case 27: {
                this.hidePopupWindow(false);
                break;
            }
            case 12: {
                if (this.keyListener == null) break;
                this.label.removeListener(1, this.keyListener);
            }
        }
    }

    private void hidePopupWindow(boolean drop) {
        this._displayHidePopupWindow(false);
    }

    private void _displayHidePopupWindow(boolean show) {
        if (show == this.isPopupVisible()) {
            return;
        }
        if (!show) {
            this.popup.setVisible(false);
            if (!this.isDisposed()) {
                this.label.setFocus();
            }
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            this.popup.dispose();
            this.popup = null;
            this.createPopupShell();
        }
        Point textRect = this.label.toDisplay(this.label.getLocation().x, this.label.getLocation().y);
        int x = textRect.x;
        int y = textRect.y + this.label.getSize().y;
        this.popup.setLocation(x, y);
        this.popup.setVisible(true);
        this.popup.setFocus();
    }

    private void createPopupShell() {
        int[] popupEvents;
        this.popup = new Shell(this.getShell(), 16392);
        this.popup.setLayout((Layout)new GridLayout());
        int[] nArray = popupEvents = new int[]{21, 9, 27, 12};
        int n = popupEvents.length;
        int n2 = 0;
        while (n2 < n) {
            int popupEvent = nArray[n2];
            this.popup.addListener(popupEvent, this.listener);
            ++n2;
        }
        this.composite = new CalculatorButtonsComposite((Composite)this.popup, 0);
        this.composite.setLayoutData(new GridData(4, 4, true, true));
        this.composite.setDisplayArea(this.label);
        this.keyListener = this.composite.getKeyListener();
        this.label.addListener(1, this.keyListener);
        this.popup.pack();
    }

    private void handleButtonEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocusEvent(15);
                break;
            }
            case 13: {
                this._displayHidePopupWindow(!this.isPopupVisible());
            }
        }
    }

    private void handleFocusEvent(int eventType) {
        if (this.isDisposed()) {
            return;
        }
        switch (eventType) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrow) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(16, e);
            }
        }
    }

    private boolean isPopupVisible() {
        return !this.popup.isDisposed() && this.popup.getVisible();
    }

    private void handleMultiChoiceEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.popup = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.hidePopupWindow(false);
                break;
            }
            case 11: {
                if (!this.isPopupVisible()) break;
                this.hidePopupWindow(false);
            }
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        this.composite.addModifyListener(listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        GC gc = new GC((Drawable)this.label);
        int spacer = gc.stringExtent((String)"                    ").x;
        int textWidth = gc.stringExtent((String)this.label.getText()).x;
        gc.dispose();
        Point textSize = this.label.computeSize(-1, -1, changed);
        Point arrowSize = this.arrow.computeSize(-1, -1, changed);
        int borderWidth = this.getBorderWidth();
        height = Math.max(textSize.y, arrowSize.y);
        width = textWidth + 2 * spacer + arrowSize.x + 2 * borderWidth;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width + 2 * borderWidth, height + 2 * borderWidth);
    }

    public String getValue() {
        this.checkWidget();
        return this.label.getText();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        this.composite.removeModifyListener(listener);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.arrow.setEnabled(enabled);
        this.label.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setToolTipText(String txt) {
        this.checkWidget();
        this.label.setToolTipText(txt);
    }

    public void setValue(String value) {
        this.checkWidget();
        new Double(value);
        this.label.setText(value);
    }
}

