/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.preferencewindow.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.opal.preferencewindow.enabler.Enabler;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class PWWidget {
    private final String propertyKey;
    private final String label;
    protected Enabler enabler;
    private final List<Control> controls;
    private int alignment = 1;
    private int indent = 0;
    private int width = 100;
    private int height = -1;
    protected int numberOfColumns = 1;
    private boolean grabExcessSpace = false;
    private boolean singleWidget = false;

    protected PWWidget(String label, String propertyKey, int numberOfColumns, boolean singleWidget) {
        this.label = label;
        this.propertyKey = propertyKey;
        this.numberOfColumns = numberOfColumns;
        this.singleWidget = singleWidget;
        this.controls = new ArrayList<Control>();
    }

    protected abstract Control build(Composite var1);

    protected void buildLabel(Composite parent, int verticalAlignment) {
        if (this.getLabel() != null) {
            Label label = new Label(parent, 0);
            label.setText(this.getLabel());
            GridData labelGridData = new GridData(3, verticalAlignment, false, false);
            labelGridData.horizontalIndent = this.getIndent();
            label.setLayoutData((Object)labelGridData);
            this.addControl((Control)label);
        }
    }

    protected abstract void check();

    public Control checkAndBuild(Composite parent) {
        this.check();
        return this.build(parent);
    }

    public boolean enableOrDisable() {
        if (this.enabler == null) {
            return true;
        }
        boolean enabled = this.enabler.isEnabled();
        for (Control c : this.controls) {
            if (c.isDisposed()) continue;
            c.setEnabled(enabled);
        }
        return enabled;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public List<Control> getControls() {
        return this.controls;
    }

    public boolean isGrabExcessSpace() {
        return this.grabExcessSpace;
    }

    public int getHeight() {
        return this.height;
    }

    public int getIndent() {
        return this.indent;
    }

    public String getLabel() {
        return this.label;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    String getPropertyKey() {
        return this.propertyKey;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isSingleWidget() {
        return this.singleWidget;
    }

    protected void addControl(Control control) {
        this.controls.add(control);
    }

    public PWWidget setAlignment(int alignment) {
        if (alignment != 1 && alignment != 2 && alignment != 3 && alignment != 4) {
            throw new UnsupportedOperationException("Value should be one of the following :GridData.BEGINNING, GridData.CENTER, GridData.END, GridData.FILL");
        }
        this.alignment = alignment;
        return this;
    }

    public PWWidget setEnabler(Enabler enabler) {
        this.enabler = enabler;
        this.enabler.injectWidget(this);
        return this;
    }

    public PWWidget setGrabExcessSpace(boolean grabExcessSpace) {
        this.grabExcessSpace = grabExcessSpace;
        return this;
    }

    public PWWidget setHeight(int height) {
        this.height = height;
        return this;
    }

    public PWWidget setIndent(int indent) {
        this.indent = indent;
        return this;
    }

    public PWWidget setWidth(int width) {
        this.width = width;
        return this;
    }
}

