/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.customize;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.customize.IXViewerCustomizations;
import org.eclipse.nebula.widgets.xviewer.util.XViewerException;
import org.eclipse.nebula.widgets.xviewer.util.internal.FileUtil;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;

public class FileStoreCustomizations
implements IXViewerCustomizations {
    private final File baseStorage;
    private final String prefix;
    private final String postfix;
    private final String defaultCustomizationFileName;
    private final CustomizeData defaultCustomData;

    public FileStoreCustomizations(File pathToCustomizations, String fileNamePrefix, String fileNamePostfix, String defaultCustomizationFileName, String defaultCustomDataXml) {
        this.baseStorage = pathToCustomizations;
        this.prefix = fileNamePrefix;
        this.postfix = fileNamePostfix;
        this.defaultCustomizationFileName = defaultCustomizationFileName;
        this.defaultCustomData = new CustomizeData(defaultCustomDataXml);
    }

    @Override
    public void deleteCustomization(CustomizeData custData) throws Exception {
        boolean success;
        File file = new File(this.getFilename(custData));
        if (file.exists() && !(success = file.delete())) {
            throw new XViewerException(XViewerText.get("error.delete_customization"));
        }
    }

    @Override
    public List<CustomizeData> getSavedCustDatas() throws XViewerException {
        ArrayList<CustomizeData> custDatas = new ArrayList<CustomizeData>();
        for (String filename : FileUtil.readListFromDir(this.getCustomDataDir(), new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(FileStoreCustomizations.this.postfix) && name.startsWith(FileStoreCustomizations.this.prefix);
            }
        })) {
            custDatas.add(new CustomizeData(FileUtil.fileToString(new File(this.getCustomDataDir(), filename))));
        }
        return custDatas;
    }

    @Override
    public CustomizeData getUserDefaultCustData() throws XViewerException {
        File file = new File(this.getDefaultFilename());
        if (!file.exists()) {
            return this.defaultCustomData;
        }
        String defaultGuid = FileUtil.fileToString(file).replaceAll("\\s", "");
        if (defaultGuid != null) {
            for (CustomizeData custData : this.getSavedCustDatas()) {
                if (!custData.getGuid().equals(defaultGuid)) continue;
                return custData;
            }
        }
        return null;
    }

    @Override
    public boolean isCustomizationPersistAvailable() {
        return true;
    }

    @Override
    public boolean isCustomizationUserDefault(CustomizeData custData) throws XViewerException {
        File file = new File(this.getDefaultFilename());
        if (!file.exists()) {
            return false;
        }
        String defaultGuid = FileUtil.fileToString(new File(this.getDefaultFilename())).replaceAll("\\s", "");
        return custData.getGuid().equals(defaultGuid);
    }

    @Override
    public void saveCustomization(CustomizeData custData) throws Exception {
        FileUtil.writeStringToFile(custData.getXml(true), new File(this.getFilename(custData)));
    }

    private String getFilename(CustomizeData custData) {
        return new File(this.getCustomDataDir(), this.prefix + custData.getGuid() + this.postfix).getAbsolutePath();
    }

    private String getDefaultFilename() {
        return new File(this.getCustomDataDir(), this.defaultCustomizationFileName).getAbsolutePath();
    }

    private File getCustomDataDir() {
        return this.baseStorage;
    }

    @Override
    public void setUserDefaultCustData(CustomizeData newCustData, boolean set) throws XViewerException {
        if (set) {
            try {
                FileUtil.writeStringToFile(newCustData.getGuid(), new File(this.getDefaultFilename()));
            }
            catch (IOException ex) {
                XViewerLog.log(FileStoreCustomizations.class, Level.SEVERE, ex);
            }
        } else {
            boolean success;
            File file = new File(this.getDefaultFilename());
            if (file.exists() && !(success = file.delete())) {
                throw new XViewerException(XViewerText.get("error.delete_customization"));
            }
        }
    }
}

