/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativePackageEntry;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativeTouchpoint;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class CheckAndPromptNativePackageWindowsRegistry
extends ProvisioningAction {
    public static final String ID = "checkAndPromptNativePackageWindowsRegistry";
    public static final String WINDOWS_DISTRO = "windows";
    private static final boolean IS_WINDOWS = File.separatorChar == '\\';
    private static final String IS_INSTALLED = "isInstalled.bat";
    private static final String SHELL = "cmd.exe";

    public IStatus execute(Map<String, Object> parameters) {
        if (!IS_WINDOWS) {
            return Status.OK_STATUS;
        }
        String packageName = (String)parameters.get("package");
        String packageVersion = (String)parameters.get("version");
        String key = (String)parameters.get("key");
        String attName = (String)parameters.get("attributeName");
        String attValue = (String)parameters.get("attributeValue");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        if (key == null || attName != null && attValue == null) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", Messages.Incorrect_Command);
        }
        File scriptToExecute = NativeTouchpoint.getFileFromBundle(WINDOWS_DISTRO, IS_INSTALLED);
        if (scriptToExecute == null) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", NLS.bind((String)Messages.Cannot_Find_status, (Object)WINDOWS_DISTRO));
        }
        try {
            ArrayList<String> cmd = new ArrayList<String>(6);
            cmd.add(SHELL);
            cmd.add("/c");
            cmd.add(scriptToExecute.getAbsolutePath());
            cmd.add(key);
            if (attName != null) {
                cmd.add(attName);
                cmd.add(attValue);
            }
            int exitValue = new ProcessBuilder(cmd).start().waitFor();
            switch (exitValue) {
                case 0: {
                    return Status.OK_STATUS;
                }
            }
            NativePackageEntry packageEntry = new NativePackageEntry(packageName, packageVersion, null);
            String downloadLink = (String)parameters.get("downloadLink");
            packageEntry.setDownloadLink(downloadLink);
            ((NativeTouchpoint)this.getTouchpoint()).addPackageToInstall(packageEntry, iu);
            ((NativeTouchpoint)this.getTouchpoint()).setDistro(WINDOWS_DISTRO);
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", NLS.bind((String)Messages.Cannot_Check_Package, (Object[])new String[]{packageName, packageVersion, WINDOWS_DISTRO}));
        }
        catch (InterruptedException e) {
            return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", NLS.bind((String)Messages.Cannot_Check_Package, (Object[])new String[]{packageName, packageVersion, WINDOWS_DISTRO}));
        }
    }

    public IStatus undo(Map<String, Object> parameters) {
        return null;
    }
}

