/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.impl;

import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.targlets.ComponentDefinition;
import org.eclipse.oomph.targlets.ProductGenerator;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.TargletPackage;
import org.eclipse.oomph.targlets.impl.ComponentDefGeneratorImpl;
import org.eclipse.oomph.util.Predicate;
import org.eclipse.oomph.util.ReflectUtil;

public class ProductGeneratorImpl
extends ModelElementImpl
implements ProductGenerator {
    private static final Set<String> FRAGMENT_SUFFIXES;

    static {
        LinkedHashSet<CallSite> suffixes = new LinkedHashSet<CallSite>();
        String[] stringArray = Platform.knownOSValues();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String os = stringArray[n2];
            suffixes.add((CallSite)((Object)("." + os)));
            ++n2;
        }
        stringArray = Platform.knownOSArchValues();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String arch = stringArray[n2];
            suffixes.add((CallSite)((Object)("." + arch)));
            ++n2;
        }
        FRAGMENT_SUFFIXES = Collections.unmodifiableSet(suffixes);
    }

    protected ProductGeneratorImpl() {
    }

    protected EClass eStaticClass() {
        return TargletPackage.Literals.PRODUCT_GENERATOR;
    }

    @Override
    public void generateIUs(IProject project, final String qualifierReplacement, Map<String, Version> iuVersions, final EList<IInstallableUnit> result) throws Exception {
        Predicate<IFile> filter = new Predicate<IFile>(){

            public boolean apply(IFile file) {
                return "product".equals(file.getFileExtension());
            }
        };
        ResourcesUtil.runWithFiles((IProject)project, (IPath)Path.EMPTY, (Predicate)filter, (ResourcesUtil.RunnableWithFile)new ResourcesUtil.RunnableWithFile(){

            public void run(File projectFolder, File file) throws Exception {
                ProductFile productDescriptor = new ProductFile(file.getAbsolutePath());
                ComponentDefinition componentDefinition = TargletFactory.eINSTANCE.createComponentDefinition();
                componentDefinition.setID(productDescriptor.getId());
                componentDefinition.setVersion(Version.create((String)productDescriptor.getVersion()));
                this.addRequirements(componentDefinition, productDescriptor.getFeatures(3), ".feature.group");
                try {
                    Method oldGetBundlesMethod = ReflectUtil.getMethod(IProductDescriptor.class, (String)"getBundles", (Class[])new Class[]{Boolean.TYPE});
                    this.addRequirements(componentDefinition, (List)ReflectUtil.invokeMethod((Method)oldGetBundlesMethod, (Object)productDescriptor, (Object[])new Object[]{true}), "");
                }
                catch (RuntimeException ex) {
                    this.addRequirements(componentDefinition, productDescriptor.getBundles(), "");
                }
                IInstallableUnit iu = ComponentDefGeneratorImpl.generateIU(componentDefinition, qualifierReplacement);
                result.add((Object)iu);
            }

            private void addRequirements(ComponentDefinition componentDefinition, List<IVersionedId> versionedIds, String idSuffix) {
                EList<Requirement> requirements = componentDefinition.getRequirements();
                for (IVersionedId versionedId : versionedIds) {
                    String id = versionedId.getId() + idSuffix;
                    Version version = versionedId.getVersion();
                    Requirement requirement = P2Factory.eINSTANCE.createRequirement(id, version, true);
                    int index = id.lastIndexOf(46);
                    if (index != -1 && FRAGMENT_SUFFIXES.contains(id.substring(index))) {
                        requirement.setOptional(true);
                    }
                    requirements.add((Object)requirement);
                }
            }
        });
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                try {
                    this.generateIUs((IProject)arguments.get(0), (String)arguments.get(1), (Map)arguments.get(2), (EList<IInstallableUnit>)((EList)arguments.get(3)));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }
}

