/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.cdatetime;

public class Header {
    static final int DATE_NOW = 0;
    static final int MONTH_PREV = 1;
    static final int MONTH_NEXT = 2;
    static final int YEAR_PREV = 3;
    static final int YEAR_NEXT = 4;
    static final int MONTH = 5;
    static final int YEAR = 6;
    static final int TIME = 7;
    int type;
    int[] fields;
    int textAlignment = 0x1000000;
    int alignment = 4;
    boolean grab = false;
    boolean readOnly = false;

    public static Header DateNow() {
        return new Header(0, 1, 2);
    }

    public static Header Month() {
        return new Header(5, 2);
    }

    public static Header MonthNext() {
        return new Header(2, 2);
    }

    public static Header MonthPrev() {
        return new Header(1, 2);
    }

    public static Header Time() {
        return new Header(7, 10, 11, 12);
    }

    public static Header Year() {
        return new Header(6, 1);
    }

    public static Header YearNext() {
        return new Header(4, 1);
    }

    public static Header YearPrev() {
        return new Header(3, 1);
    }

    private Header(int type, int ... field) {
        this.type = type;
        this.fields = field;
    }

    public Header align(int alignment) {
        this.alignment = alignment;
        return this;
    }

    public Header align(int textAlignment, int controlAlignment, boolean grab) {
        this.textAlignment = textAlignment;
        this.alignment = controlAlignment;
        this.grab = grab;
        return this;
    }

    public Header grab() {
        this.grab = true;
        return this;
    }

    public Header readOnly() {
        this.readOnly = true;
        return this;
    }
}

