/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.scr.impl.logger.BundleLogger;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.DSVersion;
import org.apache.felix.scr.impl.metadata.PropertyMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.apache.felix.scr.impl.xml.XmlConstants;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlHandler
extends DefaultHandler {
    private final Bundle m_bundle;
    private final BundleLogger m_logger;
    private final boolean m_globalObsoleteFactoryComponentFactory;
    private final boolean m_globalDelayedKeepInstances;
    private final ServiceReference<?> m_trueCondition;
    private ComponentMetadata m_currentComponent;
    private ServiceMetadata m_currentService;
    private List<ComponentMetadata> m_components = new ArrayList<ComponentMetadata>();
    private PropertyMetadata m_pendingProperty;
    private PropertyMetadata m_pendingFactoryProperty;
    private StringBuilder propertyBuilder;
    protected boolean firstElement = true;
    protected String overrideNamespace;
    protected boolean isComponent = false;

    public XmlHandler(Bundle bundle, BundleLogger logger, boolean globalObsoleteFactoryComponentFactory, boolean globalDelayedKeepInstances, ServiceReference<?> trueCondition) {
        this.m_bundle = bundle;
        this.m_logger = logger;
        this.m_globalObsoleteFactoryComponentFactory = globalObsoleteFactoryComponentFactory;
        this.m_globalDelayedKeepInstances = globalDelayedKeepInstances;
        this.m_trueCondition = trueCondition;
    }

    public List<ComponentMetadata> getComponentMetadataList() {
        return this.m_components;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        DSVersion namespaceCode;
        if (this.firstElement) {
            this.firstElement = false;
            if (localName.equals("component") && "".equals(uri)) {
                this.overrideNamespace = "http://www.osgi.org/xmlns/scr/v1.0.0";
            }
        }
        if (this.overrideNamespace != null && "".equals(uri)) {
            uri = this.overrideNamespace;
        }
        if (this.isComponent && "".equals(uri)) {
            uri = "http://www.osgi.org/xmlns/scr/v1.0.0";
        }
        if ((namespaceCode = XmlConstants.NAMESPACE_CODE_MAP.get(uri)) != null) {
            try {
                if (localName.equals("component")) {
                    String init;
                    String configurationPidString;
                    this.isComponent = true;
                    this.m_currentComponent = new ComponentMetadata(namespaceCode);
                    if (attributes.getValue("", "name") != null) {
                        this.m_currentComponent.setName(attributes.getValue("", "name"));
                    }
                    if (attributes.getValue("", "enabled") != null) {
                        this.m_currentComponent.setEnabled(attributes.getValue("", "enabled").equals("true"));
                    }
                    if (attributes.getValue("", "immediate") != null) {
                        this.m_currentComponent.setImmediate(attributes.getValue("", "immediate").equals("true"));
                    }
                    if (attributes.getValue("", "factory") != null) {
                        this.m_currentComponent.setFactoryIdentifier(attributes.getValue("", "factory"));
                    }
                    if (attributes.getValue("", "configuration-policy") != null) {
                        this.m_currentComponent.setConfigurationPolicy(attributes.getValue("", "configuration-policy"));
                    }
                    if (attributes.getValue("", "activate") != null) {
                        this.m_currentComponent.setActivate(attributes.getValue("", "activate"));
                    }
                    if (attributes.getValue("", "deactivate") != null) {
                        this.m_currentComponent.setDeactivate(attributes.getValue("", "deactivate"));
                    }
                    if (attributes.getValue("", "modified") != null) {
                        this.m_currentComponent.setModified(attributes.getValue("", "modified"));
                    }
                    if ((configurationPidString = attributes.getValue("", "configuration-pid")) != null) {
                        String[] configurationPid = configurationPidString.split(" ");
                        this.m_currentComponent.setConfigurationPid(configurationPid);
                    }
                    this.m_currentComponent.setConfigurableServiceProperties("true".equals(attributes.getValue("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "configurableServiceProperties")));
                    this.m_currentComponent.setPersistentFactoryComponent("true".equals(attributes.getValue("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "persistentFactoryComponent")));
                    this.m_currentComponent.setDeleteCallsModify("true".equals(attributes.getValue("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "deleteCallsModify")));
                    if (attributes.getValue("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "obsoleteFactoryComponentFactory") != null) {
                        this.m_currentComponent.setObsoleteFactoryComponentFactory("true".equals(attributes.getValue("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "obsoleteFactoryComponentFactory")));
                    } else if (!namespaceCode.isDS13()) {
                        this.m_currentComponent.setObsoleteFactoryComponentFactory(this.m_globalObsoleteFactoryComponentFactory);
                    }
                    this.m_currentComponent.setConfigureWithInterfaces("true".equals(attributes.getValue("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "configureWithInterfaces")));
                    this.m_currentComponent.setDelayedKeepInstances(this.m_globalDelayedKeepInstances || "true".equals(attributes.getValue("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "delayedKeepInstances")));
                    String activationFields = attributes.getValue("", "activation-fields");
                    if (activationFields != null) {
                        String[] fields = activationFields.split(" ");
                        this.m_currentComponent.setActivationFields(fields);
                    }
                    if ((init = attributes.getValue("", "init")) != null) {
                        this.m_currentComponent.setInit(init);
                    }
                    this.m_components.add(this.m_currentComponent);
                    return;
                }
                if (!this.isComponent) {
                    this.m_logger.log(InternalLogger.Level.DEBUG, "Not currently parsing a component; ignoring element {0} (bundle {1})", null, localName, this.m_bundle.getLocation());
                    return;
                }
                if (localName.equals("implementation")) {
                    this.m_currentComponent.setImplementationClassName(attributes.getValue("", "class"));
                    return;
                }
                if (localName.equals("property")) {
                    PropertyMetadata prop = new PropertyMetadata();
                    prop.setName(attributes.getValue("", "name"));
                    if (attributes.getValue("", "type") != null) {
                        prop.setType(attributes.getValue("", "type"));
                    }
                    if (attributes.getValue("", "value") != null) {
                        prop.setValue(attributes.getValue("", "value"));
                        this.m_currentComponent.addProperty(prop);
                        return;
                    }
                    this.m_pendingProperty = prop;
                    return;
                }
                if (localName.equals("properties")) {
                    Properties props = this.readPropertiesEntry(attributes.getValue("", "entry"));
                    for (Map.Entry<Object, Object> pEntry : props.entrySet()) {
                        PropertyMetadata prop = new PropertyMetadata();
                        prop.setName(String.valueOf(pEntry.getKey()));
                        prop.setValue(String.valueOf(pEntry.getValue()));
                        this.m_currentComponent.addProperty(prop);
                    }
                    return;
                }
                if (localName.equals("factory-property")) {
                    PropertyMetadata prop = new PropertyMetadata();
                    prop.setName(attributes.getValue("", "name"));
                    if (attributes.getValue("", "type") != null) {
                        prop.setType(attributes.getValue("", "type"));
                    }
                    if (attributes.getValue("", "value") != null) {
                        prop.setValue(attributes.getValue("", "value"));
                        this.m_currentComponent.addFactoryProperty(prop);
                        return;
                    }
                    this.m_pendingFactoryProperty = prop;
                    return;
                }
                if (localName.equals("factory-properties")) {
                    Properties props = this.readPropertiesEntry(attributes.getValue("", "entry"));
                    for (Map.Entry<Object, Object> pEntry : props.entrySet()) {
                        PropertyMetadata prop = new PropertyMetadata();
                        prop.setName(String.valueOf(pEntry.getKey()));
                        prop.setValue(String.valueOf(pEntry.getValue()));
                        this.m_currentComponent.addFactoryProperty(prop);
                    }
                    return;
                }
                if (localName.equals("service")) {
                    this.m_currentService = new ServiceMetadata();
                    if (attributes.getValue("", "servicefactory") != null) {
                        this.m_currentService.setServiceFactory(attributes.getValue("", "servicefactory").equals("true"));
                    }
                    if (attributes.getValue("", "scope") != null) {
                        this.m_currentService.setScope(attributes.getValue("", "scope"));
                    }
                    this.m_currentComponent.setService(this.m_currentService);
                    return;
                }
                if (localName.equals("provide")) {
                    this.m_currentService.addProvide(attributes.getValue("", "interface"));
                    return;
                }
                if (localName.equals("reference")) {
                    ReferenceMetadata ref = new ReferenceMetadata();
                    if (attributes.getValue("", "name") != null) {
                        ref.setName(attributes.getValue("", "name"));
                    }
                    ref.setInterface(attributes.getValue("", "interface"));
                    if (attributes.getValue("", "cardinality") != null) {
                        ref.setCardinality(attributes.getValue("", "cardinality"));
                    }
                    if (attributes.getValue("", "policy") != null) {
                        ref.setPolicy(attributes.getValue("", "policy"));
                    }
                    if (attributes.getValue("", "policy-option") != null) {
                        ref.setPolicyOption(attributes.getValue("", "policy-option"));
                    }
                    if (attributes.getValue("", "scope") != null) {
                        ref.setScope(attributes.getValue("", "scope"));
                    }
                    if (attributes.getValue("", "target") != null) {
                        ref.setTarget(attributes.getValue("", "target"));
                        PropertyMetadata prop = new PropertyMetadata(true);
                        prop.setName((ref.getName() == null ? ref.getInterface() : ref.getName()) + ".target");
                        prop.setValue(attributes.getValue("", "target"));
                        this.m_currentComponent.addProperty(prop);
                    }
                    ref.setBind(attributes.getValue("", "bind"));
                    ref.setUpdated(attributes.getValue("", "updated"));
                    ref.setUnbind(attributes.getValue("", "unbind"));
                    ref.setField(attributes.getValue("", "field"));
                    ref.setFieldOption(attributes.getValue("", "field-option"));
                    ref.setCollectionType(attributes.getValue("", "field-collection-type"));
                    if (attributes.getValue("", "parameter") != null) {
                        ref.setParameter(attributes.getValue("", "parameter"));
                    }
                    this.m_currentComponent.addDependency(ref);
                    return;
                }
                if (localName.equals("components")) return;
                this.m_logger.log(InternalLogger.Level.DEBUG, "Ignoring unsupported element {0} (bundle {1})", null, localName, this.m_bundle.getLocation());
                return;
            }
            catch (Exception ex) {
                throw new SAXException("Exception during parsing", ex);
            }
        } else {
            if (localName.equals("components")) return;
            this.m_logger.log(InternalLogger.Level.DEBUG, "Ignoring unsupported element '{'{0}'}'{1} (bundle {2})", null, uri, localName, this.m_bundle.getLocation());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.overrideNamespace != null && "".equals(uri)) {
            uri = this.overrideNamespace;
        }
        if (this.isComponent && "".equals(uri)) {
            uri = "http://www.osgi.org/xmlns/scr/v1.0.0";
        }
        if ("http://www.osgi.org/xmlns/scr/v1.0.0".equals(uri)) {
            if (localName.equals("component")) {
                this.isComponent = false;
            } else if (localName.equals("property") && this.m_pendingProperty != null) {
                if (this.propertyBuilder != null) {
                    this.m_pendingProperty.setValues(this.propertyBuilder.toString());
                    this.propertyBuilder = null;
                    this.m_currentComponent.addProperty(this.m_pendingProperty);
                }
                this.m_pendingProperty = null;
            } else if (localName.equals("factory-property") && this.m_pendingFactoryProperty != null) {
                if (this.propertyBuilder != null) {
                    this.m_pendingFactoryProperty.setValues(this.propertyBuilder.toString());
                    this.propertyBuilder = null;
                    this.m_currentComponent.addFactoryProperty(this.m_pendingFactoryProperty);
                }
                this.m_pendingFactoryProperty = null;
            }
        }
        if (this.m_trueCondition != null && localName.equals("component")) {
            boolean missingSatisfyingConditionRef = true;
            for (ReferenceMetadata ref : this.m_currentComponent.getDependencies()) {
                if (!"osgi.ds.satisfying.condition".equals(ref.getName())) continue;
                missingSatisfyingConditionRef = false;
                break;
            }
            if (missingSatisfyingConditionRef) {
                ReferenceMetadata trueReference = new ReferenceMetadata();
                trueReference.setName("osgi.ds.satisfying.condition");
                trueReference.setTarget("(osgi.condition.id=true)");
                trueReference.setInterface("org.osgi.service.condition.Condition");
                trueReference.setPolicy("dynamic");
                this.m_currentComponent.addDependency(trueReference);
                PropertyMetadata prop = new PropertyMetadata(true);
                prop.setName("osgi.ds.satisfying.condition.target");
                prop.setValue("(osgi.condition.id=true)");
                this.m_currentComponent.addProperty(prop);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_pendingProperty != null || this.m_pendingFactoryProperty != null) {
            if (this.propertyBuilder == null) {
                this.propertyBuilder = new StringBuilder();
            }
            this.propertyBuilder.append(String.valueOf(ch, start, length));
        }
    }

    private Properties readPropertiesEntry(String entryName) throws SAXException {
        if (entryName == null) {
            throw new SAXException("Missing entry attribute of properties element", null);
        }
        URL entryURL = this.m_bundle.getEntry(entryName);
        if (entryURL == null) {
            throw new SAXException("Missing bundle entry " + entryName, null);
        }
        Properties props = new Properties();
        InputStream entryStream = null;
        try {
            entryStream = entryURL.openStream();
            props.load(entryStream);
        }
        catch (IOException ioe) {
            throw new SAXException("Failed to read properties entry " + entryName, ioe);
        }
        finally {
            if (entryStream != null) {
                try {
                    entryStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }
}

