/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import org.eclipse.oomph.internal.ui.FlatButton;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class ToggleSwitchButton
extends FlatButton {
    private boolean selected;
    private static final Color WHITE = UIPlugin.getColor(255, 255, 255);
    private Color selectedColor = UIPlugin.getColor(58, 195, 4);
    private Color unselectedColor = UIPlugin.getColor(216, 217, 219);

    public ToggleSwitchButton(Composite parent) {
        super(parent, 32);
        this.setCornerWidth(15);
        this.setShowButtonDownState(false);
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToggleSwitchButton.this.setSelected(!ToggleSwitchButton.this.isSelected());
            }
        });
        this.updateSelected();
        this.setSelected(true);
    }

    @Override
    protected Point getTotalSize() {
        return new Point(25, 16);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            this.selected = selected;
            this.updateSelected();
        }
    }

    private void updateSelected() {
        this.setBackground(this.selected ? this.selectedColor : this.unselectedColor);
        this.redraw();
    }

    @Override
    public void drawBackground(GC gc, int x, int y, int width, int height, int offsetX, int offsetY) {
        super.drawBackground(gc, x, y, width, height, offsetX, offsetY);
    }

    @Override
    protected void drawFocusState(GC gc, int x, int y, int width, int height) {
    }

    @Override
    protected void drawContent(PaintEvent e) {
        GC gc = e.gc;
        Color oldBackground = gc.getBackground();
        int startX = this.selected ? 10 : 2;
        gc.setBackground(WHITE);
        gc.fillOval(startX, 1, 14, 14);
        gc.setBackground(oldBackground);
    }
}

