/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.Activator;
import org.eclipse.equinox.internal.p2.core.DefaultAgentProvider;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class ProvisioningAgentProvider
extends DefaultAgentProvider {
    private BundleContext context;

    public void activate(BundleContext context) {
        this.context = FrameworkUtil.getBundle(IProvisioningAgentProvider.class).getBundleContext();
        super.activate(this.context);
    }

    public IProvisioningAgent createAgent(URI location) {
        if (location == null) {
            File folder;
            String path;
            URI rootLocation;
            if (!Platform.inDevelopmentMode() && Activator.agentDataLocation != null && (rootLocation = Activator.agentDataLocation.getRootLocation()) != null && (path = rootLocation.getPath()) != null && !IOUtil.canWriteFolder((File)(folder = new File(path)))) {
                try {
                    URI defaultLocation = URIUtil.append((URI)URIUtil.fromString((String)(this.context.getProperty("osgi.configuration.area") + "../p2")), (String)"");
                    ReflectUtil.setValue((String)"location", (Object)Activator.agentDataLocation, (Object)defaultLocation);
                }
                catch (URISyntaxException defaultLocation) {}
            }
        } else {
            File dataAreaFolder;
            Map properties;
            String dataArea;
            File configIniFile;
            File folder;
            String path = location.getRawPath();
            if (path != null && path.endsWith("/../p2") && !(folder = new File(path)).isDirectory() && (configIniFile = new File(folder.getParentFile().getParentFile(), "config.ini")).isFile() && (dataArea = (String)(properties = PropertiesUtil.loadProperties((File)configIniFile)).get("eclipse.p2.data.area")) != null && dataArea.startsWith("file:/") && (dataAreaFolder = new File(dataArea.substring("file:/".length() - 1))).isDirectory()) {
                try {
                    location = URIUtil.fromString((String)AgentImpl.createFileURI(dataAreaFolder));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return super.createAgent(location);
    }
}

