/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.util.Objects;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class EditorElement
extends QuickAccessElement {
    private static final String DIRTY_MARK = "*";
    private final IEditorReference editorReference;
    private final boolean dirty;

    EditorElement(IEditorReference editorReference) {
        this.editorReference = editorReference;
        this.dirty = editorReference.isDirty();
    }

    @Override
    public void execute() {
        IWorkbenchPage activePage;
        IWorkbenchPart part = this.editorReference.getPart(true);
        if (part != null && (activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            activePage.activate(part);
        }
    }

    @Override
    public String getId() {
        return this.editorReference.getId() + this.editorReference.getTitleToolTip();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        Image titleImage = this.editorReference.getTitleImage();
        if (titleImage == null) {
            return null;
        }
        return ImageDescriptor.createFromImage((Image)titleImage);
    }

    @Override
    public String getLabel() {
        return (this.dirty ? DIRTY_MARK : "") + this.editorReference.getTitle() + " - " + this.editorReference.getTitleToolTip();
    }

    @Override
    public String getSortLabel() {
        return this.editorReference.getTitle();
    }

    public int hashCode() {
        return Objects.hashCode(this.editorReference);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EditorElement other = (EditorElement)obj;
        return Objects.equals(this.editorReference, other.editorReference);
    }
}

