/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.ui.internal.workspace.markers.Translation;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.views.markers.QuickFixPage;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class QuickFixWizard
extends Wizard {
    private final IMarker[] selectedMarkers;
    private final Map<IMarkerResolution, Collection<IMarker>> resolutionMap;
    private final String description;
    private final Consumer<StructuredViewer> showMarkers;
    private final Consumer<Control> bindHelp;
    private final Consumer<Throwable> reporter;
    private QuickFixPage quickFixPage;

    public QuickFixWizard(String description, IMarker[] selectedMarkers, Map<IMarkerResolution, Collection<IMarker>> resolutions, Consumer<StructuredViewer> showMarkers, Consumer<Control> bindHelp, Consumer<Throwable> reporter) {
        Objects.requireNonNull(reporter);
        this.selectedMarkers = selectedMarkers;
        this.resolutionMap = resolutions;
        this.description = description;
        this.showMarkers = showMarkers;
        this.bindHelp = bindHelp;
        this.reporter = reporter;
        this.setDefaultPageImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_DLGBAN_QUICKFIX_DLG"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.quickFixPage = new QuickFixPage(this.description, this.selectedMarkers, this.resolutionMap, this.showMarkers, this.bindHelp);
        this.addPage((IWizardPage)this.quickFixPage);
    }

    public boolean performFinish() {
        Optional<IMarkerResolution> resolution = this.quickFixPage.getSelectedMarkerResolution();
        if (!resolution.isPresent()) {
            return true;
        }
        IMarker[] markers = this.quickFixPage.getCheckedMarkers();
        if (markers.length == 0) {
            return true;
        }
        IRunnableWithProgress finishRunnable = monitor -> this.processResolution((IMarkerResolution)resolution.get(), markers, monitor);
        try {
            this.getContainer().run(false, true, finishRunnable);
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.reporter.accept(e);
            return false;
        }
        return true;
    }

    private void processResolution(IMarkerResolution resolution, IMarker[] markers, IProgressMonitor monitor) {
        monitor.beginTask(MarkerMessages.MarkerResolutionDialog_Fixing, markers.length);
        this.ensureRepaint();
        if (resolution instanceof WorkbenchMarkerResolution) {
            ((WorkbenchMarkerResolution)resolution).run(markers, monitor);
        } else {
            Translation translation = new Translation();
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                this.ensureRepaint();
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.subTask(translation.message(marker).orElse(""));
                resolution.run(marker);
                monitor.worked(1);
                ++n2;
            }
        }
    }

    private void ensureRepaint() {
        Display display = this.getShell().getDisplay();
        boolean dispatch = true;
        while (dispatch) {
            dispatch = display.readAndDispatch();
        }
    }
}

