/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.internal.databinding.viewers.CheckboxTreeViewerUpdater;
import org.eclipse.jface.internal.databinding.viewers.ObservableViewerElementSet;
import org.eclipse.jface.internal.databinding.viewers.TreeViewerUpdater;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementMap;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public abstract class ObservableCollectionTreeContentProvider<E>
implements ITreeContentProvider {
    private final Realm realm;
    private final Display display;
    private IObservableValue<Viewer> viewerObservable;
    protected IElementComparer comparer;
    private final IObservableFactory<Viewer, IObservableSet<E>> elementSetFactory;
    protected TreeViewerUpdater viewerUpdater;
    protected IObservableSet<E> knownElements;
    private IObservableSet<E> unmodifiableKnownElements;
    protected IObservableSet<E> realizedElements;
    private IObservableSet<E> unmodifiableRealizedElements;
    private IObservableFactory<? super E, ? extends IObservableCollection<E>> collectionFactory;
    private Map<E, TreeNode> elementNodes;
    private final TreeStructureAdvisor<? super E> structureAdvisor;
    boolean asyncUpdatePending;
    Runnable asyncUpdateRunnable;

    protected ObservableCollectionTreeContentProvider(IObservableFactory<? super E, ? extends IObservableCollection<E>> collectionFactory, TreeStructureAdvisor<? super E> structureAdvisor) {
        this.structureAdvisor = structureAdvisor;
        this.display = Display.getDefault();
        this.realm = DisplayRealm.getRealm(this.display);
        this.viewerObservable = new WritableValue(this.realm);
        this.viewerUpdater = null;
        this.elementSetFactory = target -> ObservableViewerElementSet.withComparer(this.realm, null, ObservableCollectionTreeContentProvider.getElementComparer(target));
        this.knownElements = MasterDetailObservables.detailSet(this.viewerObservable, this.elementSetFactory, null);
        this.unmodifiableKnownElements = Observables.unmodifiableObservableSet(this.knownElements);
        Assert.isNotNull(collectionFactory, (String)"Collection factory cannot be null");
        this.collectionFactory = collectionFactory;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.elementNodes != null && !this.elementNodes.isEmpty()) {
            TreeNode[] oldNodes = new TreeNode[this.elementNodes.size()];
            this.elementNodes.values().toArray(oldNodes);
            TreeNode[] treeNodeArray = oldNodes;
            int n = oldNodes.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode oldNode = treeNodeArray[n2];
                oldNode.dispose();
                ++n2;
            }
            this.elementNodes.clear();
            this.elementNodes = null;
        }
        this.setViewer(viewer);
        this.knownElements.clear();
        if (this.realizedElements != null) {
            this.realizedElements.clear();
        }
        if (newInput != null) {
            this.getElements(newInput);
        }
    }

    private void setViewer(Viewer viewer) {
        this.viewerUpdater = ObservableCollectionTreeContentProvider.createViewerUpdater(viewer);
        this.comparer = ObservableCollectionTreeContentProvider.getElementComparer(viewer);
        this.elementNodes = ViewerElementMap.withComparer(this.comparer);
        this.viewerObservable.setValue((Object)viewer);
    }

    private static IElementComparer getElementComparer(Viewer viewer) {
        if (viewer instanceof StructuredViewer) {
            return ((StructuredViewer)viewer).getComparer();
        }
        return null;
    }

    private static TreeViewerUpdater createViewerUpdater(Viewer viewer) {
        if (viewer instanceof CheckboxTreeViewer) {
            return new CheckboxTreeViewerUpdater((CheckboxTreeViewer)viewer);
        }
        if (viewer instanceof AbstractTreeViewer) {
            return new TreeViewerUpdater((AbstractTreeViewer)viewer);
        }
        throw new IllegalArgumentException("This content provider only works with AbstractTreeViewer");
    }

    public Object getParent(Object element) {
        Object parentFromAdvisor;
        if (this.structureAdvisor != null && (parentFromAdvisor = this.structureAdvisor.getParent(element)) != null) {
            return parentFromAdvisor;
        }
        TreeNode node = this.getExistingNode(element);
        if (node != null) {
            return node.getParent();
        }
        return null;
    }

    public Object[] getElements(Object input) {
        return this.getChildren(input, true);
    }

    public Object[] getChildren(Object element) {
        return this.getChildren(element, false);
    }

    private Object[] getChildren(Object element, boolean input) {
        Object[] children;
        TreeNode node = this.getOrCreateNode(element, input);
        Object[] objectArray = children = node.getChildren().toArray();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object childElement = objectArray[n2];
            this.getOrCreateNode(childElement, false).addParent(element);
            ++n2;
        }
        this.asyncUpdateRealizedElements();
        return children;
    }

    private void asyncUpdateRealizedElements() {
        if (this.realizedElements == null) {
            return;
        }
        if (this.asyncUpdatePending) {
            return;
        }
        if (!this.realizedElements.equals(this.knownElements)) {
            if (this.asyncUpdateRunnable == null) {
                this.asyncUpdateRunnable = () -> {
                    if (this.knownElements == null) {
                        return;
                    }
                    this.asyncUpdatePending = false;
                    if (this.realizedElements != null) {
                        this.realizedElements.addAll(this.knownElements);
                    }
                };
            }
            this.asyncUpdatePending = true;
            this.display.asyncExec(this.asyncUpdateRunnable);
        }
    }

    public boolean hasChildren(Object element) {
        Boolean hasChildren;
        if (this.structureAdvisor != null && (hasChildren = this.structureAdvisor.hasChildren(element)) != null) {
            return hasChildren;
        }
        return this.getOrCreateNode(element, false).hasChildren();
    }

    protected TreeNode getOrCreateNode(E element) {
        return this.getOrCreateNode(element, false);
    }

    private TreeNode getOrCreateNode(E element, boolean input) {
        TreeNode node = this.getExistingNode(element);
        if (node == null) {
            node = new TreeNode(element);
            this.elementNodes.put(element, node);
        }
        if (!input) {
            this.knownElements.add(element);
        }
        return node;
    }

    protected TreeNode getExistingNode(E element) {
        return this.elementNodes.get(element);
    }

    protected boolean isViewerDisposed() {
        Viewer viewer = (Viewer)this.viewerObservable.getValue();
        return viewer == null || viewer.getControl() == null || viewer.getControl().isDisposed();
    }

    public void dispose() {
        if (this.elementNodes != null) {
            if (!this.elementNodes.isEmpty()) {
                TreeNode[] nodes = new TreeNode[this.elementNodes.size()];
                this.elementNodes.values().toArray(nodes);
                TreeNode[] treeNodeArray = nodes;
                int n = nodes.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeNode node = treeNodeArray[n2];
                    node.dispose();
                    ++n2;
                }
                this.elementNodes.clear();
            }
            this.elementNodes = null;
        }
        if (this.viewerObservable != null) {
            this.viewerObservable.dispose();
            this.viewerObservable = null;
        }
        this.viewerUpdater = null;
        this.comparer = null;
        this.knownElements = null;
        this.unmodifiableKnownElements = null;
        this.collectionFactory = null;
        this.asyncUpdateRunnable = null;
    }

    public IObservableSet<E> getKnownElements() {
        return this.unmodifiableKnownElements;
    }

    public IObservableSet<E> getRealizedElements() {
        if (this.realizedElements == null) {
            this.realizedElements = MasterDetailObservables.detailSet(this.viewerObservable, this.elementSetFactory, null);
            this.unmodifiableRealizedElements = Observables.unmodifiableObservableSet(this.realizedElements);
            this.asyncUpdateRealizedElements();
        }
        return this.unmodifiableRealizedElements;
    }

    protected Set<E> findPendingRemovals(E parent, Collection<? extends E> elementsToBeRemoved) {
        Set result = ViewerElementSet.withComparer(this.comparer);
        Set<E> parents = ViewerElementSet.withComparer(this.comparer);
        parents.add(parent);
        this.accumulatePendingRemovals(result, parents, elementsToBeRemoved);
        return result;
    }

    private void accumulatePendingRemovals(Set<E> removals, Set<E> parents, Collection<? extends E> elementsToRemove) {
        for (E element : elementsToRemove) {
            TreeNode node = this.getExistingNode(element);
            if (node == null || !parents.containsAll(node.getParents())) continue;
            removals.add(element);
            parents.add(element);
            Collection children = node.getChildren();
            this.accumulatePendingRemovals(removals, parents, children);
        }
    }

    protected abstract IObservablesListener createCollectionChangeListener(E var1);

    protected abstract void addCollectionChangeListener(IObservableCollection<E> var1, IObservablesListener var2);

    protected abstract void removeCollectionChangeListener(IObservableCollection<E> var1, IObservablesListener var2);

    protected boolean equal(Object left, Object right) {
        if (this.comparer == null) {
            return Objects.equals(left, right);
        }
        return this.comparer.equals(left, right);
    }

    protected final class TreeNode {
        private E element;
        private E parent;
        private Set<E> parentSet;
        private IObservableCollection<E> children;
        private IObservablesListener listener;

        TreeNode(E element) {
            Assert.isNotNull(element, (String)"element cannot be null");
            this.element = element;
        }

        Object getElement() {
            return this.element;
        }

        public void addParent(E newParent) {
            if (this.parent == null) {
                this.parent = newParent;
            } else if (!ObservableCollectionTreeContentProvider.this.equal(this.parent, newParent)) {
                if (this.parentSet == null) {
                    this.parentSet = ViewerElementSet.withComparer(ObservableCollectionTreeContentProvider.this.comparer);
                    this.parentSet.add(this.parent);
                }
                this.parentSet.add(newParent);
            }
        }

        public void removeParent(Object oldParent) {
            if (this.parentSet != null) {
                this.parentSet.remove(oldParent);
                if (this.parentSet.isEmpty()) {
                    this.parentSet = null;
                }
            }
            if (ObservableCollectionTreeContentProvider.this.equal(this.parent, oldParent)) {
                this.parent = this.parentSet == null ? null : this.parentSet.iterator().next();
            }
            if (this.parent == null) {
                this.dispose();
            }
        }

        private E getParent() {
            return this.parent;
        }

        public Set<E> getParents() {
            if (this.parentSet != null) {
                return this.parentSet;
            }
            if (this.parent != null) {
                return Collections.singleton(this.parent);
            }
            return Collections.EMPTY_SET;
        }

        private void initChildren() {
            if (this.children == null) {
                this.children = (IObservableCollection)ObservableCollectionTreeContentProvider.this.collectionFactory.createObservable(this.element);
                if (this.children == null) {
                    this.listener = null;
                    this.children = Observables.emptyObservableSet((Realm)ObservableCollectionTreeContentProvider.this.realm);
                } else {
                    Assert.isTrue((boolean)Objects.equals(ObservableCollectionTreeContentProvider.this.realm, this.children.getRealm()), (String)"Children observable collection must be on the Display realm");
                    this.listener = ObservableCollectionTreeContentProvider.this.createCollectionChangeListener(this.element);
                    ObservableCollectionTreeContentProvider.this.addCollectionChangeListener(this.children, this.listener);
                    ObservableCollectionTreeContentProvider.this.knownElements.addAll(this.children);
                }
            }
        }

        boolean hasChildren() {
            this.initChildren();
            return !this.children.isEmpty();
        }

        public Collection<E> getChildren() {
            this.initChildren();
            return this.children;
        }

        private void dispose() {
            if (this.element != null) {
                ObservableCollectionTreeContentProvider.this.elementNodes.remove(this.element);
            }
            if (this.children != null && !this.children.isDisposed()) {
                for (Object elem : this.children) {
                    TreeNode child = ObservableCollectionTreeContentProvider.this.getExistingNode(elem);
                    if (child == null) continue;
                    child.removeParent(this.element);
                }
                if (this.listener != null) {
                    ObservableCollectionTreeContentProvider.this.removeCollectionChangeListener(this.children, this.listener);
                }
                this.children.dispose();
                this.children = null;
            }
            this.element = null;
            this.parent = null;
            if (this.parentSet != null) {
                this.parentSet.clear();
                this.parentSet = null;
            }
        }
    }
}

