/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.setup.ui.Messages;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractConfirmDialog
extends AbstractSetupDialog {
    private final String rememberButtonText;
    private boolean remember;

    public AbstractConfirmDialog(Shell parentShell, String title, int width, int height, String rememberButtonText) {
        super(parentShell, title, width, height, SetupUIPlugin.INSTANCE, false);
        this.rememberButtonText = rememberButtonText;
    }

    public AbstractConfirmDialog(String title, int width, int height, String rememberButtonText) {
        this(null, title, width, height, rememberButtonText);
    }

    public boolean isRemember() {
        return this.remember;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        final Button rememberButton = this.createCheckbox(parent, this.rememberButtonText);
        rememberButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractConfirmDialog.this.remember = rememberButton.getSelection();
            }
        });
        String rememberButtonToolTip = this.getRememberButtonToolTip();
        if (!StringUtil.isEmpty((String)rememberButtonToolTip)) {
            rememberButton.setToolTipText(rememberButtonToolTip);
        }
        this.doCreateButtons(parent);
    }

    protected void doCreateButtons(Composite parent) {
        this.createButton(parent, 0, Messages.AbstractConfirmDialog_accept, false);
        this.createButton(parent, 1, Messages.AbstractConfirmDialog_decline, true);
    }

    protected String getRememberButtonToolTip() {
        return null;
    }
}

