/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.templating;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bndtools.templating.Category;
import org.bndtools.templating.Template;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RepoTemplateContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final boolean flat;
    private Object input;
    private Object[] roots;

    public RepoTemplateContentProvider(boolean flat) {
        this.flat = flat;
    }

    public void dispose() {
    }

    private void recalculateRoots() {
        Collection<Object> templates = this.input instanceof Object[] ? Arrays.asList((Template[])this.input) : (this.input instanceof Collection ? (Collection)this.input : Collections.emptyList());
        if (this.flat) {
            this.roots = templates.toArray();
        } else {
            List categories = Category.categorise(templates);
            this.roots = categories.toArray();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput;
        this.recalculateRoots();
    }

    public boolean isFlat() {
        return this.flat;
    }

    public Object[] getElements(Object input) {
        return this.roots;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Category) {
            Collection templates = ((Category)parentElement).getTemplates();
            return templates.toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Category) {
            return !((Category)element).getTemplates().isEmpty();
        }
        return false;
    }

    public Template getFirstTemplate() {
        Category cat;
        Iterator templateIter;
        Template result = null;
        if (this.roots != null && this.roots.length > 0 && this.roots[0] instanceof Category && (templateIter = (cat = (Category)this.roots[0]).getTemplates().iterator()).hasNext()) {
            result = (Template)templateIter.next();
        }
        return result;
    }
}

