/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.breadcrumb;

import org.eclipse.debug.internal.ui.viewers.breadcrumb.BreadcrumbItemDetails;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.BreadcrumbItemDropDown;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.BreadcrumbViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class BreadcrumbItem
extends Item {
    private TreePath fPath;
    private final BreadcrumbViewer fParent;
    private final Composite fContainer;
    private final BreadcrumbItemDropDown fExpandBlock;
    private final BreadcrumbItemDetails fDetailsBlock;
    private boolean fIsLast;

    public BreadcrumbItem(BreadcrumbViewer viewer, Composite parent) {
        super((Widget)parent, 0);
        this.fParent = viewer;
        this.fContainer = new Composite(parent, 0);
        this.fContainer.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this.fContainer.setLayout((Layout)layout);
        this.fExpandBlock = new BreadcrumbItemDropDown(this, this.fContainer);
        this.fDetailsBlock = new BreadcrumbItemDetails(this, this.fContainer);
        this.fContainer.setData("org.eclipse.e4.ui.css.id", (Object)"DebugBreadcrumbItemComposite");
    }

    public BreadcrumbViewer getViewer() {
        return this.fParent;
    }

    public void dispose() {
        this.fContainer.dispose();
        super.dispose();
    }

    public TreePath getPath() {
        return this.fPath;
    }

    public void setPath(TreePath path) {
        this.fPath = path;
    }

    void setShowText(boolean enabled) {
        this.fDetailsBlock.setTextVisible(enabled);
    }

    boolean isShowText() {
        return this.fDetailsBlock.isTextVisible();
    }

    int getWidth() {
        return this.fDetailsBlock.getWidth() + this.fExpandBlock.getWidth() + 2;
    }

    void setSelected(boolean selected) {
        this.fDetailsBlock.setSelected(selected);
    }

    void setFocus(boolean state) {
        this.fDetailsBlock.setFocus(state);
    }

    boolean hasFocus() {
        return this.fDetailsBlock.hasFocus();
    }

    void setIsLastItem(boolean isLast) {
        this.fIsLast = isLast;
        GridData data = (GridData)this.fContainer.getLayoutData();
        data.grabExcessHorizontalSpace = isLast;
    }

    void openDropDownMenu() {
        this.fExpandBlock.showMenu();
    }

    boolean isMenuShown() {
        return this.fExpandBlock.isMenuShown();
    }

    Shell getDropDownShell() {
        return this.fExpandBlock.getDropDownShell();
    }

    public Rectangle getBounds() {
        return this.fContainer.getBounds();
    }

    public void setToolTip(String text) {
        this.fDetailsBlock.setToolTip(text);
    }

    public void setText(String string) {
        super.setText(string);
        this.fDetailsBlock.setText(string);
        if (this.fIsLast) {
            this.fContainer.layout(true, true);
        }
    }

    public void setImage(Image image) {
        super.setImage(image);
        this.fDetailsBlock.setImage(image);
    }
}

