/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.jdt.internal.ui.text.AbstractFastJavaPartitionScanner;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class FastJavaPartitioner
extends FastPartitioner {
    private boolean fIsTextBlockSupported = false;

    public FastJavaPartitioner(IPartitionTokenScanner scanner, String[] legalContentTypes) {
        super(scanner, legalContentTypes);
    }

    protected void initialize() {
        super.initialize();
        this.fIsTextBlockSupported = this.isTextBlockSupported();
    }

    public void resetPositionCache() {
        this.clearPositionCache();
    }

    public void documentAboutToBeChanged(DocumentEvent e) {
        super.documentAboutToBeChanged(e);
        if (this.hasTextBlockSupportedValueChanged()) {
            this.clearManagingPositionCategory();
            this.connect(this.fDocument, false);
        }
    }

    public ITypedRegion[] computePartitioning(int offset, int length, boolean includeZeroLengthPartitions) {
        if (this.hasTextBlockSupportedValueChanged()) {
            this.clearManagingPositionCategory();
            this.connect(this.fDocument, false);
        }
        return super.computePartitioning(offset, length, includeZeroLengthPartitions);
    }

    public void cleanAndReConnectDocumentIfNecessary() {
        if (this.hasTextBlockSupportedValueChanged()) {
            this.clearManagingPositionCategory();
            this.connect(this.fDocument, false);
        }
    }

    public boolean hasTextBlockSupportedValueChanged() {
        boolean textBlockSupportedValueChanged = false;
        boolean textBlockSupported = this.isTextBlockSupported();
        if (textBlockSupported != this.fIsTextBlockSupported) {
            textBlockSupportedValueChanged = true;
        }
        return textBlockSupportedValueChanged;
    }

    private boolean isTextBlockSupported() {
        boolean isTextBlockSupported = false;
        isTextBlockSupported = this.fScanner instanceof AbstractFastJavaPartitionScanner ? ((AbstractFastJavaPartitionScanner)this.fScanner).isTextBlockSupported() : false;
        return isTextBlockSupported;
    }

    private void clearManagingPositionCategory() {
        String[] categories;
        String[] stringArray = categories = this.getManagingPositionCategories();
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            try {
                this.fDocument.removePositionCategory(category);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            ++n2;
        }
        this.clearPositionCache();
    }
}

