/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApiDescriptionXmlCreator
extends ApiDescriptionVisitor {
    private final Element fComponent;
    private final Document fDoc = Util.newDocument();
    private Element fPackage;
    private int fPackageVisibility;
    private final Stack<Element> fTypeStack;
    private final Set<String> fVisitedPackages;

    public ApiDescriptionXmlCreator(IApiComponent component) throws CoreException {
        this(component.getName(), component.getSymbolicName());
    }

    public ApiDescriptionXmlCreator(String componentName, String componentId) throws CoreException {
        this.fComponent = this.fDoc.createElement("component");
        this.fComponent.setAttribute("name", componentName);
        this.fComponent.setAttribute("version", "1.2");
        this.fDoc.appendChild(this.fComponent);
        Element plugin = this.fDoc.createElement("plugin");
        plugin.setAttribute("id", componentId);
        this.fComponent.appendChild(plugin);
        this.fVisitedPackages = new HashSet<String>();
        this.fTypeStack = new Stack();
    }

    private void annotateElementAttributes(IApiAnnotations description, Element element) {
        element.setAttribute("restrictions", Integer.toString(description.getRestrictions()));
        int visibility = description.getVisibility();
        if (visibility != this.fPackageVisibility) {
            element.setAttribute("visibility", Integer.toString(visibility));
        }
    }

    @Override
    public void endVisitElement(IElementDescriptor element, IApiAnnotations description) {
        int elementType = element.getElementType();
        if (elementType == 1) {
            if (this.fPackage != null && this.fPackage.hasChildNodes()) {
                this.fComponent.appendChild(this.fPackage);
            }
            this.fPackage = null;
        } else if (elementType == 2) {
            this.fTypeStack.pop();
        }
    }

    public Document getXML() {
        return this.fDoc;
    }

    @Override
    public boolean visitElement(IElementDescriptor element, IApiAnnotations description) {
        switch (element.getElementType()) {
            case 1: {
                IPackageDescriptor pkg = (IPackageDescriptor)element;
                String pkgName = pkg.getName();
                if (!this.fVisitedPackages.add(pkgName)) break;
                this.fPackage = this.fDoc.createElement("package");
                this.fPackage.setAttribute("name", pkgName);
                this.fPackageVisibility = description.getVisibility();
                this.fPackage.setAttribute("visibility", Integer.toString(this.fPackageVisibility));
                this.fVisitedPackages.add(pkgName);
                break;
            }
            case 2: {
                IReferenceTypeDescriptor typeDesc = (IReferenceTypeDescriptor)element;
                this.fTypeStack.push(this.fDoc.createElement("type"));
                Element type = this.fTypeStack.peek();
                this.annotateElementAttributes(description, type);
                this.fPackage.appendChild(type);
                type.setAttribute("name", Signatures.getSimpleTypeName(typeDesc.getQualifiedName()));
                break;
            }
            case 6: {
                IMethodDescriptor desc = (IMethodDescriptor)element;
                Element method = this.fDoc.createElement("method");
                Element type = this.fTypeStack.peek();
                this.annotateElementAttributes(description, method);
                if (!method.hasAttributes()) break;
                type.appendChild(method);
                method.setAttribute("signature", desc.getSignature());
                method.setAttribute("name", desc.getName());
                break;
            }
            case 5: {
                IFieldDescriptor desc = (IFieldDescriptor)element;
                Element field = this.fDoc.createElement("field");
                Element type = this.fTypeStack.peek();
                this.annotateElementAttributes(description, field);
                if (!field.hasAttributes()) break;
                type.appendChild(field);
                field.setAttribute("name", desc.getName());
                break;
            }
        }
        return true;
    }
}

