/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class UpdateCorrectHeaderName
extends AbstractManifestMarkerResolution {
    private static final Logger logger = Logger.getLogger(UpdateCorrectHeaderName.class.getName());

    public UpdateCorrectHeaderName(int type, IMarker marker) {
        super(type, marker);
    }

    public String getLabel() {
        return PDEUIMessages.RemoveInvalidCharacters;
    }

    private String removeInvalidChars(String userHeader) {
        return userHeader.replaceAll("[^a-zA-Z0-9-_]", "");
    }

    @Override
    protected void createChange(BundleModel model) {
        model.getBundle();
        IDocument doc = model.getDocument();
        try {
            int lineNum = this.marker.getAttribute("lineNumber", -1);
            IRegion lineInfo = doc.getLineInformation(lineNum - 1);
            int offset = lineInfo.getOffset();
            int length = lineInfo.getLength();
            String getLine = doc.get(offset, length);
            int colonInd = getLine.indexOf(58);
            if (colonInd > 0) {
                String userHeader = getLine.substring(0, colonInd);
                String correctHeader = this.removeInvalidChars(userHeader);
                doc.replace(offset, colonInd, correctHeader);
            }
        }
        catch (BadLocationException e) {
            logger.log(Level.SEVERE, "Failed to apply UpdateCorrectHeaderName quick fix, unexpected location in the doc", e);
        }
    }
}

