/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.doc;

import java.io.IOException;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.ecl.core.util.EclTypeNameConvention;
import org.eclipse.rcptt.ecl.doc.EclDocParameterDocumentation;
import org.eclipse.rcptt.ecl.doc.EclDocWriter;
import org.eclipse.rcptt.ecl.doc.IEclDocProvider;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;

public class EclDocParameter
implements IEclDocProvider {
    private EStructuralFeature efeature;
    private EclDocParameterDocumentation docs;

    public EclDocParameter(EStructuralFeature efeature) {
        this.efeature = efeature;
    }

    public String getName() {
        return this.efeature.getName();
    }

    public boolean isInternal() {
        return this.efeature.getEAnnotation("http://www.eclipse.org/ecl/internal") != null;
    }

    public boolean isInput() {
        return this.efeature.getEAnnotation("http://www.eclipse.org/ecl/input") != null;
    }

    public boolean isOptional() {
        return !this.efeature.isRequired();
    }

    public String getTypeName() {
        return this.efeature.getEType().getName();
    }

    public String getFriendlyTypeName() {
        return EclTypeNameConvention.toTypeName((String)this.getTypeName());
    }

    public String getFriendlyDefaultLiteral() {
        String result = this.efeature.getDefaultValueLiteral();
        if (!this.getFriendlyTypeName().equals("String")) {
            return result;
        }
        if (result == null || result.length() == 0) {
            return "\"\"";
        }
        return String.valueOf('\"') + result + '\"';
    }

    public EclDocParameterDocumentation getDocumentation() {
        if (this.docs == null) {
            this.docs = new EclDocParameterDocumentation(this);
        }
        return this.docs;
    }

    public EStructuralFeature getEFeature() {
        return this.efeature;
    }

    public int getLowerBound() {
        return this.efeature.getLowerBound();
    }

    public int getUpperBound() {
        return this.efeature.getUpperBound();
    }

    @Override
    public void writeEclDoc(EclDocWriter w) throws IOException {
        String literal;
        String desc = this.getDocumentation().getDescription();
        desc = CoreUtils.isBlank((String)desc) ? this.getName() : desc;
        w.text(desc);
        w.dl();
        w.dt("Type:");
        String typeName = this.getTypeName();
        String friendlyTypeName = this.getFriendlyTypeName();
        if (!friendlyTypeName.equals(typeName)) {
            w.dd(String.format("%s (%s)", friendlyTypeName, typeName));
        } else {
            w.dd(String.format("%s", typeName));
        }
        w.close();
        int lower = this.getLowerBound();
        int upper = this.getUpperBound();
        String quantity = null;
        if (upper != lower) {
            quantity = lower == 0 && upper == 1 ? "Parameter is optional." : (upper >= lower ? String.format("From %s to %s.", lower, upper) : String.format("From %s to \u221e.", lower));
        } else if (lower != 1) {
            quantity = String.format("Exactly %s.", lower);
        }
        if (!CoreUtils.isBlank(quantity)) {
            w.dl();
            w.dt("Quantity:");
            w.dd(quantity);
            w.close();
        }
        String string = literal = this.isOptional() ? this.getFriendlyDefaultLiteral() : null;
        if (!CoreUtils.isBlank((String)literal)) {
            w.dl();
            w.dt("Default value:");
            w.dd(literal);
            w.close();
        }
        if (this.isInput()) {
            w.text("<p>This parameter is marked as <i>input</i> parameter and may be omited. In this case, actual argument value will be taken from the pipe. Typically, that will be a result of the previous command execution.</p>");
        }
    }
}

