/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.wrapper.shape;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Statements;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSourceHelper;

public class RepositoryConnectionShapeSource
implements ShapeSource {
    private final RepositoryConnection connection;
    private final Resource[] context;

    public RepositoryConnectionShapeSource(RepositoryConnection connection) {
        this(connection, null);
    }

    private RepositoryConnectionShapeSource(RepositoryConnection connection, Resource[] context) {
        this.connection = connection;
        this.context = context;
        assert (connection.isActive());
    }

    @Override
    public RepositoryConnectionShapeSource withContext(Resource[] context) {
        return new RepositoryConnectionShapeSource(this.connection, context);
    }

    @Override
    public Resource[] getActiveContexts() {
        return this.context;
    }

    @Override
    public Stream<ShapeSource.ShapesGraph> getAllShapeContexts() {
        Stream shapesGraphStream;
        assert (this.context == null);
        Stream<ShapeSource.ShapesGraph> rsxDataAndShapesGraphLink = ShapeSource.getRsxDataAndShapesGraphLink(this.connection, this.context);
        try (Stream stream = this.connection.getStatements(null, SHACL.SHAPES_GRAPH, null, false, new Resource[0]).stream();){
            shapesGraphStream = stream.collect(Collectors.groupingBy(Statement::getSubject)).entrySet().stream().map(entry -> new ShapeSource.ShapesGraph((Resource)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList()).stream();
        }
        return Stream.concat(rsxDataAndShapesGraphLink, shapesGraphStream);
    }

    @Override
    public Stream<Resource> getTargetableShape() {
        assert (this.context != null);
        return Stream.of(this.getSubjects(ShapeSource.Predicates.TARGET_NODE), this.getSubjects(ShapeSource.Predicates.TARGET_CLASS), this.getSubjects(ShapeSource.Predicates.TARGET_SUBJECTS_OF), this.getSubjects(ShapeSource.Predicates.TARGET_OBJECTS_OF), this.getSubjects(ShapeSource.Predicates.TARGET_PROP), this.getSubjects(ShapeSource.Predicates.RSX_targetShape)).reduce(Stream::concat).get().distinct();
    }

    @Override
    public boolean isType(Resource subject, IRI type) {
        if (DASH_CONSTANTS.contains(subject, RDF.TYPE, (Value)type, new Resource[0]) || this.connection.hasStatement(subject, RDF.TYPE, (Value)type, true, this.context)) {
            return true;
        }
        if (type != SHACL.NODE_SHAPE && type != SHACL.PROPERTY_SHAPE) {
            if (type.equals((Object)SHACL.NODE_SHAPE)) {
                type = SHACL.NODE_SHAPE;
            } else if (type.equals((Object)SHACL.PROPERTY_SHAPE)) {
                type = SHACL.PROPERTY_SHAPE;
            }
        }
        if (type == SHACL.PROPERTY_SHAPE) {
            return this.connection.hasStatement(subject, SHACL.PATH, null, true, this.context);
        }
        if (type == SHACL.NODE_SHAPE) {
            if (this.connection.hasStatement(subject, SHACL.PATH, null, true, this.context)) {
                return false;
            }
            if (this.connection.hasStatement(null, SHACL.NODE, (Value)subject, true, this.context)) {
                return true;
            }
            try (Stream stream = this.connection.getStatements(subject, null, null, true, this.context).stream();){
                boolean bl = stream.map(Statement::getPredicate).map(Value::stringValue).anyMatch(predicate -> predicate.startsWith("http://www.w3.org/ns/shacl#") || predicate.startsWith("http://datashapes.org/dash#"));
                return bl;
            }
        }
        return false;
    }

    @Override
    public Stream<Resource> getSubjects(ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return this.connection.getStatements(null, predicate.getIRI(), null, true, this.context).stream().map(Statement::getSubject).distinct();
    }

    @Override
    public Stream<Value> getObjects(Resource subject, ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return this.connection.getStatements(subject, predicate.getIRI(), null, true, this.context).stream().map(Statement::getObject).distinct();
    }

    @Override
    public Stream<Statement> getAllStatements(Resource id) {
        assert (this.context != null);
        return this.connection.getStatements(id, null, null, true, this.context).stream().map(Statements::stripContext).distinct();
    }

    @Override
    public Value getRdfFirst(Resource subject) {
        return ShapeSourceHelper.getFirst(this.connection, subject, this.context);
    }

    @Override
    public Resource getRdfRest(Resource subject) {
        return ShapeSourceHelper.getRdfRest(this.connection, subject, this.context);
    }

    @Override
    public void close() {
    }
}

