/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.results;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.RSX;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.Severity;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.SparqlConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ValidationResult {
    private static final Logger logger = LoggerFactory.getLogger(ValidationResult.class);
    private Resource id;
    private final Optional<Value> value;
    private final Shape shape;
    private final SourceConstraintComponent sourceConstraintComponent;
    private final ConstraintComponent sourceConstraint;
    private final Severity severity;
    private final Value focusNode;
    private final Resource[] dataGraphs;
    private final Resource[] shapesGraphs;
    private Path path;
    private Path rsxPairwisePath;
    private ValidationResult detail;
    private Value pathIri;

    public ValidationResult(Value focusNode, Value value, Shape shape, ConstraintComponent sourceConstraint, Severity severity, ConstraintComponent.Scope scope, Resource[] dataGraphs, Resource[] shapesGraphs) {
        this.focusNode = focusNode;
        assert (this.focusNode != null);
        this.sourceConstraintComponent = sourceConstraint.getConstraintComponent();
        this.sourceConstraint = sourceConstraint;
        this.shape = shape;
        if (this.sourceConstraintComponent.producesValidationResultValue()) {
            assert (!this.sourceConstraintComponent.alwaysProducesValidationResultValue() || value != null);
            if (value == null && this.sourceConstraintComponent.alwaysProducesValidationResultValue()) {
                logger.error("Source constraint component {} was expected to produce a value, but value is null! Shape: {}", (Object)this.sourceConstraintComponent, (Object)shape);
            }
            this.value = Optional.ofNullable(value);
        } else {
            assert (scope != ConstraintComponent.Scope.propertyShape || value == null);
            this.value = Optional.empty();
        }
        if (shape instanceof PropertyShape) {
            this.path = ((PropertyShape)shape).getPath();
        }
        this.severity = severity;
        this.dataGraphs = dataGraphs;
        this.shapesGraphs = shapesGraphs;
    }

    public ValidationResult(Value focusNode, Value value, Shape shape, ConstraintComponent sourceConstraint, Severity severity, ConstraintComponent.Scope scope, Resource[] dataGraphs, Resource[] shapesGraphs, Path rsxPairwisePath) {
        this(focusNode, value, shape, sourceConstraint, severity, scope, dataGraphs, shapesGraphs);
        this.rsxPairwisePath = rsxPairwisePath;
    }

    public ValidationResult getDetail() {
        return this.detail;
    }

    public void setDetail(ValidationResult detail) {
        this.detail = detail;
    }

    public List<ValidationResult> getDetails() {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        ValidationResult temp = this.detail;
        while (temp != null) {
            validationResults.add(temp);
            temp = temp.detail;
        }
        return validationResults;
    }

    public Model asModel(Model model) {
        return this.asModel(model, new HashSet<Resource>());
    }

    public Model asModel(Model model, Set<Resource> rdfListDedupe) {
        model.add(this.getId(), RDF.TYPE, (Value)SHACL.VALIDATION_RESULT, new Resource[0]);
        model.add(this.getId(), SHACL.FOCUS_NODE, this.focusNode, new Resource[0]);
        for (Resource graph : ValidationResult.contextsToSet(this.dataGraphs)) {
            model.add(this.getId(), RSX.dataGraph, (Value)graph, new Resource[0]);
        }
        for (Resource graph : ValidationResult.contextsToSet(this.shapesGraphs)) {
            model.add(this.getId(), RSX.shapesGraph, (Value)graph, new Resource[0]);
        }
        this.value.ifPresent(v -> model.add(this.getId(), SHACL.VALUE, v, new Resource[0]));
        if (this.pathIri != null) {
            model.add(this.getId(), SHACL.RESULT_PATH, this.pathIri, new Resource[0]);
        } else if (this.path != null) {
            this.path.toModel(this.path.getId(), null, model, new HashSet<Resource>());
            model.add(this.getId(), SHACL.RESULT_PATH, (Value)this.path.getId(), new Resource[0]);
        }
        if (this.rsxPairwisePath != null) {
            this.rsxPairwisePath.toModel(this.rsxPairwisePath.getId(), null, model, new HashSet<Resource>());
            model.add(this.getId(), RSX.actualPairwisePath, (Value)this.rsxPairwisePath.getId(), new Resource[0]);
        }
        if (this.sourceConstraint instanceof SparqlConstraintComponent) {
            model.add(this.getId(), SHACL.SOURCE_CONSTRAINT, (Value)((SparqlConstraintComponent)this.sourceConstraint).getId(), new Resource[0]);
        }
        model.add(this.getId(), SHACL.SOURCE_CONSTRAINT_COMPONENT, (Value)this.getSourceConstraintComponent().getIri(), new Resource[0]);
        model.add(this.getId(), SHACL.RESULT_SEVERITY, this.severity.getIri(), new Resource[0]);
        for (Literal message : this.shape.getMessage()) {
            model.add(this.getId(), SHACL.RESULT_MESSAGE, (Value)message, new Resource[0]);
        }
        this.shape.toModel(this.getId(), SHACL.SOURCE_SHAPE, model, new HashSet<Resource>());
        return model;
    }

    private static Set<Resource> contextsToSet(Resource[] context) {
        if (context == null || context.length == 0) {
            return Collections.emptySet();
        }
        return Arrays.stream(context).map(c -> c == null ? RDF4J.NIL : c).collect(Collectors.toSet());
    }

    private Path getPath() {
        return this.path;
    }

    private Value getFocusNode() {
        return this.focusNode;
    }

    public final Resource getId() {
        if (this.id == null) {
            this.id = Values.bnode();
        }
        return this.id;
    }

    public SourceConstraintComponent getSourceConstraintComponent() {
        return this.sourceConstraintComponent;
    }

    public String toString() {
        return "ValidationResult{focusNode=" + String.valueOf(this.focusNode) + ", value=" + String.valueOf(this.value.orElse(null)) + ", shape=" + String.valueOf(this.shape.getId()) + ", path=" + String.valueOf(this.path) + ", sourceConstraintComponent=" + String.valueOf((Object)this.sourceConstraintComponent) + ", severity=" + String.valueOf((Object)this.severity) + ", detail=" + String.valueOf(this.detail) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationResult that = (ValidationResult)o;
        return this.value.equals(that.value) && this.shape.equals(that.shape) && this.sourceConstraintComponent == that.sourceConstraintComponent && this.severity == that.severity && this.focusNode.equals((Object)that.focusNode) && Objects.equals(this.path, that.path) && Objects.equals(this.detail, that.detail);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.shape, this.sourceConstraintComponent, this.severity, this.focusNode, this.path, this.detail});
    }

    public void setPathIri(Value path) {
        this.pathIri = path;
    }

    protected Optional<Value> getValue() {
        return this.value;
    }

    protected Shape getShape() {
        return this.shape;
    }

    protected ConstraintComponent getSourceConstraint() {
        return this.sourceConstraint;
    }

    protected Severity getSeverity() {
        return this.severity;
    }

    protected Resource[] getDataGraphs() {
        return this.dataGraphs;
    }

    protected Resource[] getShapesGraphs() {
        return this.shapesGraphs;
    }
}

