/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks.diagnostics;

import java.lang.ref.Cleaner;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;

@InternalUseOnly
public class ConcurrentCleaner {
    private static final int MAX = 128;
    private static final Cleaner[] cleaner;
    private static final int mask;

    private static int powerOfTwoSize(int initialSize) {
        int n = -1 >>> Integer.numberOfLeadingZeros(initialSize - 1);
        return n < 0 ? 1 : (n >= 128 ? 128 : n + 1);
    }

    static int getIndex(Thread key) {
        if (key == null) {
            return 0;
        }
        return mask & (int)key.getId();
    }

    public Cleaner.Cleanable register(Object obj, Runnable action) {
        Cleaner cleaner = ConcurrentCleaner.cleaner[ConcurrentCleaner.getIndex(Thread.currentThread())];
        if (cleaner == null) {
            cleaner = ConcurrentCleaner.instantiateCleaner(ConcurrentCleaner.getIndex(Thread.currentThread()));
        }
        return cleaner.register(obj, action);
    }

    private static synchronized Cleaner instantiateCleaner(int index) {
        if (cleaner[index] == null) {
            ConcurrentCleaner.cleaner[index] = Cleaner.create();
        }
        return cleaner[index];
    }

    static {
        int concurrency = ConcurrentCleaner.powerOfTwoSize(Runtime.getRuntime().availableProcessors() * 2);
        mask = concurrency - 1;
        cleaner = new Cleaner[concurrency];
    }
}

