/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.config;

import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;
import org.eclipse.rdf4j.sail.nativerdf.config.NativeStoreConfig;
import org.eclipse.rdf4j.sail.nativerdf.wal.ValueStoreWalConfig;

public class NativeStoreFactory
implements SailFactory {
    public static final String SAIL_TYPE = "openrdf:NativeStore";

    @Override
    public String getSailType() {
        return SAIL_TYPE;
    }

    @Override
    public SailImplConfig getConfig() {
        return new NativeStoreConfig();
    }

    @Override
    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        NativeStore nativeStore = new NativeStore();
        if (config instanceof NativeStoreConfig) {
            NativeStoreConfig nativeConfig = (NativeStoreConfig)config;
            nativeConfig.getDefaultQueryEvaluationMode().ifPresent(nativeStore::setDefaultQueryEvaluationMode);
            nativeStore.setTripleIndexes(nativeConfig.getTripleIndexes());
            nativeStore.setForceSync(nativeConfig.getForceSync());
            if (nativeConfig.getValueCacheSize() >= 0) {
                nativeStore.setValueCacheSize(nativeConfig.getValueCacheSize());
            }
            if (nativeConfig.getValueIDCacheSize() >= 0) {
                nativeStore.setValueIDCacheSize(nativeConfig.getValueIDCacheSize());
            }
            if (nativeConfig.getNamespaceCacheSize() >= 0) {
                nativeStore.setNamespaceCacheSize(nativeConfig.getNamespaceCacheSize());
            }
            if (nativeConfig.getNamespaceIDCacheSize() >= 0) {
                nativeStore.setNamespaceIDCacheSize(nativeConfig.getNamespaceIDCacheSize());
            }
            if (nativeConfig.getIterationCacheSyncThreshold() > 0L) {
                nativeStore.setIterationCacheSyncThreshold(nativeConfig.getIterationCacheSyncThreshold());
            }
            if (nativeConfig.getWalMaxSegmentBytes() > 0L) {
                nativeStore.setWalMaxSegmentBytes(nativeConfig.getWalMaxSegmentBytes());
            }
            if (nativeConfig.getWalQueueCapacity() > 0) {
                nativeStore.setWalQueueCapacity(nativeConfig.getWalQueueCapacity());
            }
            if (nativeConfig.getWalBatchBufferBytes() > 0) {
                nativeStore.setWalBatchBufferBytes(nativeConfig.getWalBatchBufferBytes());
            }
            if (nativeConfig.getWalSyncPolicy() != null) {
                try {
                    nativeStore.setWalSyncPolicy(ValueStoreWalConfig.SyncPolicy.valueOf(nativeConfig.getWalSyncPolicy().toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Invalid walSyncPolicy: " + nativeConfig.getWalSyncPolicy());
                }
            }
            if (nativeConfig.getWalSyncIntervalMillis() >= 0L) {
                nativeStore.setWalSyncIntervalMillis(nativeConfig.getWalSyncIntervalMillis());
            }
            if (nativeConfig.getWalIdlePollIntervalMillis() >= 0L) {
                nativeStore.setWalIdlePollIntervalMillis(nativeConfig.getWalIdlePollIntervalMillis());
            }
            if (nativeConfig.getWalDirectoryName() != null) {
                nativeStore.setWalDirectoryName(nativeConfig.getWalDirectoryName());
            }
            nativeStore.setWalSyncBootstrapOnOpen(nativeConfig.getWalSyncBootstrapOnOpen());
            nativeStore.setWalAutoRecoverOnOpen(nativeConfig.getWalAutoRecoverOnOpen());
            nativeStore.setWalEnabled(nativeConfig.getWalEnabled());
            EvaluationStrategyFactory evalStratFactory = nativeConfig.getEvaluationStrategyFactory();
            if (evalStratFactory != null) {
                nativeStore.setEvaluationStrategyFactory(evalStratFactory);
            }
        }
        return nativeStore;
    }
}

