/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transaction;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOObjectHistory;
import org.eclipse.emf.cdo.CDOObjectReference;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitHistory;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOResourceNodeNotFoundException;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOSavepoint;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionFinishedEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler1;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler2;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.transaction.CDOTransactionStartedEvent;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.cdo.view.CDOObjectHandler;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDORegistrationHandler;
import org.eclipse.emf.cdo.view.CDOUnitManager;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;

public class CDOPushTransaction
extends Notifier
implements CDOTransaction {
    private CDOTransaction delegate;
    private File file;
    private boolean dirty;
    private CDOTransactionHandler delegateHandler = new CDOTransactionHandler(){

        @Override
        public void attachingObject(CDOTransaction transaction, CDOObject object) {
            CDOPushTransaction.this.setDirty(true);
        }

        @Override
        public void detachingObject(CDOTransaction transaction, CDOObject object) {
            CDOPushTransaction.this.setDirty(true);
        }

        @Override
        public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureDelta) {
            CDOPushTransaction.this.setDirty(true);
        }

        @Override
        public void committingTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
        }

        @Override
        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
        }

        @Override
        public void rolledBackTransaction(CDOTransaction transaction) {
        }
    };
    private final IRegistry<String, Object> properties = new HashMapRegistry<String, Object>(){

        public void setAutoCommit(boolean autoCommit) {
            throw new UnsupportedOperationException();
        }
    };

    public CDOPushTransaction(CDOTransaction delegate) throws IOException {
        this(delegate, CDOPushTransaction.createTempFile(delegate));
    }

    public CDOPushTransaction(CDOTransaction delegate, File file) throws IOException {
        this(delegate, file, true);
    }

    public CDOPushTransaction(CDOTransaction delegate, File file, boolean reconstructSavepoints) throws IOException {
        this.delegate = delegate;
        this.file = file;
        boolean delegateWasDirty = delegate.isDirty();
        delegate.addTransactionHandler(this.delegateHandler);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Not a file: " + file.getAbsolutePath());
        }
        OM.LOG.info("Using " + file.getAbsolutePath() + " for push transaction " + delegate.getSession().getRepositoryInfo().getName() + ":" + delegate.getSession().getSessionID() + ":" + delegate.getViewID());
        if (file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                delegate.importChanges(in, reconstructSavepoints);
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
            IOUtil.close((Closeable)in);
        }
        this.dirty = delegateWasDirty;
    }

    public CDOTransaction getDelegate() {
        return this.delegate;
    }

    public File getFile() {
        return this.file;
    }

    public final IRegistry<String, Object> properties() {
        return this.properties;
    }

    @Override
    public boolean isDirty() {
        return this.dirty || this.delegate.isDirty();
    }

    protected void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            if (dirty) {
                this.fireEvent(new CDOTransactionStartedEvent(){

                    @Override
                    public CDOView getSource() {
                        return CDOPushTransaction.this;
                    }
                });
            } else {
                this.fireEvent(new CDOTransactionFinishedEvent(){

                    @Override
                    public CDOView getSource() {
                        return CDOPushTransaction.this;
                    }

                    @Override
                    @Deprecated
                    public CDOTransactionFinishedEvent.Type getType() {
                        return CDOTransactionFinishedEvent.Type.COMMITTED;
                    }

                    @Override
                    public CDOTransactionFinishedEvent.Cause getCause() {
                        return CDOTransactionFinishedEvent.Cause.COMMITTED;
                    }

                    @Override
                    public Map<CDOID, CDOID> getIDMappings() {
                        return Collections.emptyMap();
                    }
                });
            }
        }
    }

    @Override
    public CDOCommitInfo commit() throws CommitException {
        return this.commit(null);
    }

    @Override
    public CDOCommitInfo commit(IProgressMonitor monitor) throws CommitException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file);
            this.delegate.exportChanges(out);
            this.setDirty(false);
        }
        catch (Exception ex) {
            try {
                throw new CommitException("A problem occured while exporting changes to " + this.file.getAbsolutePath(), ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)out);
        return null;
    }

    @Override
    @Deprecated
    public <T> CDOTransaction.CommitResult<T> commit(Callable<T> callable, org.eclipse.net4j.util.Predicate<Long> retry, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException, Exception {
        return this.delegate.commit(callable, retry, monitor);
    }

    @Override
    public <T> CDOTransaction.CommitResult<T> commit(Callable<T> callable, Predicate<Long> retry, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException, Exception {
        return this.delegate.commit(callable, retry, monitor);
    }

    @Override
    public <T> CDOTransaction.CommitResult<T> commit(Callable<T> callable, int attempts, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException, Exception {
        return this.delegate.commit(callable, attempts, monitor);
    }

    @Override
    @Deprecated
    public CDOCommitInfo commit(Runnable runnable, org.eclipse.net4j.util.Predicate<Long> retry, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        return this.delegate.commit(runnable, retry, monitor);
    }

    @Override
    public CDOCommitInfo commit(Runnable runnable, Predicate<Long> retry, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        return this.delegate.commit(runnable, retry, monitor);
    }

    @Override
    public CDOCommitInfo commit(Runnable runnable, int attempts, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        return this.delegate.commit(runnable, attempts, monitor);
    }

    @Override
    public CDOCommitInfo commitAndClose(IProgressMonitor monitor, boolean keepOpenAfterCommitProblem) throws CommitException {
        return this.delegate.commitAndClose(monitor, keepOpenAfterCommitProblem);
    }

    @Override
    public void rollback() {
        throw new UnsupportedOperationException("Rollback not supported for push transactions");
    }

    public void push() throws CommitException {
        this.push(null);
    }

    public void push(IProgressMonitor progressMonitor) throws CommitException {
        this.delegate.commit(progressMonitor);
        this.file.delete();
        this.setDirty(false);
    }

    @Override
    public CDOSavepoint[] exportChanges(OutputStream out) throws IOException {
        return this.delegate.exportChanges(out);
    }

    @Override
    public CDOSavepoint[] importChanges(InputStream in, boolean reconstructSavepoints) throws IOException {
        return this.delegate.importChanges(in, reconstructSavepoints);
    }

    @Override
    public long getLastCommitTime() {
        return this.delegate.getLastCommitTime();
    }

    public void addListener(IListener listener) {
        super.addListener(listener);
        this.delegate.addListener(listener);
    }

    public void removeListener(IListener listener) {
        super.removeListener(listener);
        this.delegate.removeListener(listener);
    }

    public boolean hasListeners() {
        return this.delegate.hasListeners();
    }

    public IListener[] getListeners() {
        return this.delegate.getListeners();
    }

    @Override
    public void addObjectHandler(CDOObjectHandler handler) {
        this.delegate.addObjectHandler(handler);
    }

    @Override
    public void addRegistrationHandler(CDORegistrationHandler handler) {
        this.delegate.addRegistrationHandler(handler);
    }

    @Override
    public void addTransactionHandler(CDOTransactionHandlerBase handler) {
        this.delegate.addTransactionHandler(handler);
    }

    public void close() {
        this.delegate.removeTransactionHandler(this.delegateHandler);
        this.delegate.close();
    }

    @Override
    public CDOQuery createQuery(String language, String queryString) {
        return this.createQuery(language, queryString, null, false);
    }

    @Override
    public CDOQuery createQuery(String language, String queryString, Object context) {
        return this.createQuery(language, queryString, context, false);
    }

    @Override
    public CDOQuery createQuery(String language, String queryString, boolean considerDirtyState) {
        return this.createQuery(language, queryString, null, considerDirtyState);
    }

    @Override
    public CDOQuery createQuery(String language, String queryString, Object context, boolean considerDirtyState) {
        return this.delegate.createQuery(language, queryString, context, considerDirtyState);
    }

    @Override
    public CDOResourceFolder createResourceFolder(String path) {
        return this.delegate.createResourceFolder(path);
    }

    @Override
    public CDOResource createResource(String path) {
        return this.delegate.createResource(path);
    }

    @Override
    @Deprecated
    public boolean isLegacyModeEnabled() {
        return this.delegate.isLegacyModeEnabled();
    }

    @Override
    public long getLastUpdateTime() {
        return this.delegate.getLastUpdateTime();
    }

    @Override
    public void waitForUpdate(long updateTime) {
        this.delegate.waitForUpdate(updateTime);
    }

    @Override
    public boolean waitForUpdate(long updateTime, long timeoutMillis) {
        return this.delegate.waitForUpdate(updateTime, timeoutMillis);
    }

    @Override
    public boolean runAfterUpdate(long updateTime, Runnable runnable) {
        return this.delegate.runAfterUpdate(updateTime, runnable);
    }

    @Override
    public Set<CDOObject> getConflicts() {
        return this.delegate.getConflicts();
    }

    public CDOChangeSetData getChangeSetData() {
        return this.delegate.getChangeSetData();
    }

    @Override
    public Map<CDOID, CDOObject> getDetachedObjects() {
        return this.delegate.getDetachedObjects();
    }

    @Override
    public Map<CDOID, CDOObject> getDirtyObjects() {
        return this.delegate.getDirtyObjects();
    }

    public CDORevision getRevision(CDOID id) {
        return this.delegate.getRevision(id);
    }

    @Override
    public CDOSavepoint getFirstSavepoint() {
        return this.delegate.getFirstSavepoint();
    }

    @Override
    public CDOSavepoint getLastSavepoint() {
        return this.delegate.getLastSavepoint();
    }

    @Override
    @Deprecated
    public boolean isInvalidationRunnerActive() {
        return this.isInvalidating();
    }

    @Override
    public boolean isInvalidating() {
        return this.delegate.isInvalidating();
    }

    @Override
    public Map<CDOID, CDOObject> getNewObjects() {
        return this.delegate.getNewObjects();
    }

    @Override
    public Map<CDOID, CDOObject> getObjects(Collection<CDOID> ids) {
        return this.delegate.getObjects(ids);
    }

    @Override
    public CDOObject getObject(CDOID id, boolean loadOnDemand) {
        return this.delegate.getObject(id, loadOnDemand);
    }

    @Override
    public CDOObject getObject(CDOID id) {
        return this.delegate.getObject(id);
    }

    @Override
    public <T extends EObject> T getObject(T objectFromDifferentView) {
        return this.delegate.getObject(objectFromDifferentView);
    }

    @Override
    public CDOObjectHandler[] getObjectHandlers() {
        return this.delegate.getObjectHandlers();
    }

    @Override
    public CDORegistrationHandler[] getRegistrationHandlers() {
        return this.delegate.getRegistrationHandlers();
    }

    @Override
    public CDOResource getOrCreateResource(String path) {
        return this.delegate.getOrCreateResource(path);
    }

    @Override
    public CDOResourceFolder getOrCreateResourceFolder(String path) {
        return this.delegate.getOrCreateResourceFolder(path);
    }

    @Override
    public CDOResource getResource(String path, boolean loadOnDemand) throws CDOResourceNodeNotFoundException {
        return this.delegate.getResource(path, loadOnDemand);
    }

    @Override
    public CDOResource getResource(String path) throws CDOResourceNodeNotFoundException {
        return this.delegate.getResource(path);
    }

    @Override
    public CDOResourceNode getResourceNode(String path) throws CDOResourceNodeNotFoundException {
        return this.delegate.getResourceNode(path);
    }

    @Override
    public CDOTextResource createTextResource(String path) {
        return this.delegate.createTextResource(path);
    }

    @Override
    public CDOTextResource getOrCreateTextResource(String path) {
        return this.delegate.getOrCreateTextResource(path);
    }

    @Override
    public CDOBinaryResource createBinaryResource(String path) {
        return this.delegate.createBinaryResource(path);
    }

    @Override
    public CDOBinaryResource getOrCreateBinaryResource(String path) {
        return this.delegate.getOrCreateBinaryResource(path);
    }

    @Override
    public CDOTextResource getTextResource(String path) throws CDOResourceNodeNotFoundException {
        return this.delegate.getTextResource(path);
    }

    @Override
    public CDOBinaryResource getBinaryResource(String path) throws CDOResourceNodeNotFoundException {
        return this.delegate.getBinaryResource(path);
    }

    @Override
    public CDOResourceFolder getResourceFolder(String path) throws CDOResourceNodeNotFoundException {
        return this.delegate.getResourceFolder(path);
    }

    @Override
    public void setResourcePathCache(Map<String, CDOID> resourcePathCache) {
        this.delegate.setResourcePathCache(resourcePathCache);
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.delegate.getResourceSet();
    }

    @Override
    public Map<CDOID, CDORevisionDelta> getRevisionDeltas() {
        return this.delegate.getRevisionDeltas();
    }

    @Override
    public CDOResource getRootResource() {
        return this.delegate.getRootResource();
    }

    @Override
    public CDOSession getSession() {
        return this.delegate.getSession();
    }

    @Override
    public CDOViewProvider getProvider() {
        return this.delegate.getProvider();
    }

    @Override
    public URI createResourceURI(String path) {
        return this.delegate.createResourceURI(path);
    }

    public long getTimeStamp() {
        return this.delegate.getTimeStamp();
    }

    public String getDurableLockingID() {
        return this.delegate.getDurableLockingID();
    }

    @Override
    public CDOTransactionHandler[] getTransactionHandlers() {
        return this.delegate.getTransactionHandlers();
    }

    @Override
    public CDOTransactionHandler1[] getTransactionHandlers1() {
        return this.delegate.getTransactionHandlers1();
    }

    @Override
    public CDOTransactionHandler2[] getTransactionHandlers2() {
        return this.delegate.getTransactionHandlers2();
    }

    public int getSessionID() {
        return this.delegate.getSessionID();
    }

    public boolean isDurableView() {
        return this.delegate.isDurableView();
    }

    public CDOLockOwner getLockOwner() {
        return this.delegate.getLockOwner();
    }

    @Override
    public URI getURI() {
        return this.delegate.getURI();
    }

    public int getViewID() {
        return this.delegate.getViewID();
    }

    @Override
    public CDOViewSet getViewSet() {
        return this.delegate.getViewSet();
    }

    @Override
    public Lock getViewLock() {
        return this.delegate.getViewLock();
    }

    @Override
    public void syncExec(Runnable runnable) {
        this.delegate.syncExec(runnable);
    }

    @Override
    public <V> V syncExec(Callable<V> callable) throws Exception {
        return this.delegate.syncExec(callable);
    }

    @Override
    public boolean hasConflict() {
        return this.delegate.hasConflict();
    }

    @Override
    public boolean hasResource(String path) {
        return this.delegate.hasResource(path);
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public boolean isObjectRegistered(CDOID id) {
        return this.delegate.isObjectRegistered(id);
    }

    @Override
    @Deprecated
    public void refreshLockStates(Consumer<CDOLockState> consumer) {
        this.delegate.refreshLockStates(consumer);
    }

    @Override
    public CDOLockState[] getLockStates(Collection<CDOID> ids) {
        return this.delegate.getLockStates(ids);
    }

    @Override
    public CDOLockState[] getLockStates(Collection<CDOID> ids, boolean loadOnDemand) {
        return this.delegate.getLockStates(ids, loadOnDemand);
    }

    @Override
    public CDOLockState[] getLockStatesOfObjects(Collection<? extends CDOObject> objects) {
        return this.delegate.getLockStatesOfObjects(objects);
    }

    @Override
    public void lockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType, long timeout) throws InterruptedException {
        this.delegate.lockObjects(objects, lockType, timeout);
    }

    @Override
    public void lockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType, long timeout, boolean recursive) throws InterruptedException {
        this.delegate.lockObjects(objects, lockType, timeout, recursive);
    }

    @Override
    public CDOTransaction.Options options() {
        return this.delegate.options();
    }

    @Override
    public List<CDOResourceNode> queryResources(CDOResourceFolder folder, String name, boolean exactMatch) {
        return this.delegate.queryResources(folder, name, exactMatch);
    }

    @Override
    public CloseableIterator<CDOResourceNode> queryResourcesAsync(CDOResourceFolder folder, String name, boolean exactMatch) {
        return this.delegate.queryResourcesAsync(folder, name, exactMatch);
    }

    @Override
    public <T extends EObject> List<T> queryInstances(EClass type) {
        return this.delegate.queryInstances(type);
    }

    @Override
    public <T extends EObject> CloseableIterator<T> queryInstancesAsync(EClass type) {
        return this.delegate.queryInstancesAsync(type);
    }

    @Override
    public <T extends EObject> CloseableIterator<T> queryInstancesAsync(EClass type, boolean exact) {
        return this.delegate.queryInstancesAsync(type, exact);
    }

    @Override
    public List<CDOObjectReference> queryXRefs(CDOObject targetObject, EReference ... sourceReferences) {
        return this.delegate.queryXRefs(targetObject, sourceReferences);
    }

    @Override
    public List<CDOObjectReference> queryXRefs(Set<CDOObject> targetObjects, EReference ... sourceReferences) {
        return this.delegate.queryXRefs(targetObjects, sourceReferences);
    }

    @Override
    public CloseableIterator<CDOObjectReference> queryXRefsAsync(Set<CDOObject> targetObjects, EReference ... sourceReferences) {
        return this.delegate.queryXRefsAsync(targetObjects, sourceReferences);
    }

    @Override
    @Deprecated
    public int reload(CDOObject ... objects) {
        return this.delegate.reload(objects);
    }

    @Override
    public void removeObjectHandler(CDOObjectHandler handler) {
        this.delegate.removeObjectHandler(handler);
    }

    @Override
    public void removeRegistrationHandler(CDORegistrationHandler handler) {
        this.delegate.removeRegistrationHandler(handler);
    }

    @Override
    public void removeTransactionHandler(CDOTransactionHandlerBase handler) {
        this.delegate.removeTransactionHandler(handler);
    }

    @Override
    public CDOChangeSetData revertTo(CDOBranchPoint branchPoint) {
        return this.delegate.revertTo(branchPoint);
    }

    @Override
    public CDOChangeSetData merge(CDOBranch source, CDOMerger merger) {
        return this.delegate.merge(source, merger);
    }

    @Override
    public CDOChangeSetData merge(CDOBranchPoint source, CDOMerger merger) {
        return this.delegate.merge(source, merger);
    }

    @Override
    public CDOChangeSetData merge(CDOBranchPoint source, CDOBranchPoint sourceBase, CDOMerger merger) {
        return this.delegate.merge(source, sourceBase, merger);
    }

    @Override
    public CDOChangeSetData merge(CDOBranchPoint source, CDOBranchPoint sourceBase, CDOBranchPoint targetBase, CDOMerger merger) {
        return this.delegate.merge(sourceBase, sourceBase, targetBase, merger);
    }

    @Override
    public CDOChangeSetData compareRevisions(CDOBranchPoint source) {
        return this.delegate.compareRevisions(source);
    }

    public CDOCommitHistory getHistory() {
        return this.delegate.getHistory();
    }

    public CDOObjectHistory getHistory(CDOObject object) {
        return (CDOObjectHistory)this.delegate.getHistory(object);
    }

    @Override
    public CDOSavepoint setSavepoint() {
        return this.delegate.setSavepoint();
    }

    @Override
    public void unlockObjects() {
        this.delegate.unlockObjects();
    }

    @Override
    public void unlockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType) {
        this.delegate.unlockObjects(objects, lockType);
    }

    @Override
    public void unlockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType, boolean recursive) {
        this.delegate.unlockObjects(objects, lockType, recursive);
    }

    @Override
    @Deprecated
    public String enableDurableLocking(boolean enable) {
        return this.delegate.enableDurableLocking(enable);
    }

    @Override
    public String enableDurableLocking() {
        return this.delegate.enableDurableLocking();
    }

    @Override
    public void disableDurableLocking(boolean releaseLocks) {
        this.delegate.disableDurableLocking(releaseLocks);
    }

    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    public boolean isHistorical() {
        return this.delegate.isHistorical();
    }

    public CDOBranch getBranch() {
        return this.delegate.getBranch();
    }

    @Override
    public boolean setBranchPoint(CDOBranch branch, long timeStamp) {
        return this.delegate.setBranchPoint(branch, timeStamp);
    }

    @Override
    public boolean setBranchPoint(CDOBranch branch, long timeStamp, IProgressMonitor monitor) {
        return this.delegate.setBranchPoint(branch, timeStamp, monitor);
    }

    @Override
    public boolean setBranchPoint(CDOBranchPoint branchPoint) {
        return this.delegate.setBranchPoint(branchPoint);
    }

    @Override
    public boolean setBranchPoint(CDOBranchPoint branchPoint, IProgressMonitor monitor) {
        return this.delegate.setBranchPoint(branchPoint, monitor);
    }

    @Override
    public boolean setBranch(CDOBranch branch) {
        return this.delegate.setBranch(branch);
    }

    @Override
    public boolean setBranch(CDOBranch branch, IProgressMonitor monitor) {
        return this.delegate.setBranch(branch, monitor);
    }

    @Override
    public boolean setTimeStamp(long timeStamp) {
        return this.delegate.setTimeStamp(timeStamp);
    }

    @Override
    public boolean setTimeStamp(long timeStamp, IProgressMonitor monitor) {
        return this.delegate.setTimeStamp(timeStamp, monitor);
    }

    @Override
    public URIHandler getURIHandler() {
        return this.delegate.getURIHandler();
    }

    @Override
    public CDOUnitManager getUnitManager() {
        return this.delegate.getUnitManager();
    }

    @Override
    public String getCommitComment() {
        return this.delegate.getCommitComment();
    }

    @Override
    public void setCommitComment(String comment) {
        this.delegate.setCommitComment(comment);
    }

    @Override
    public String getCommitProperty(String key) {
        return this.delegate.getCommitProperty(key);
    }

    @Override
    public String setCommitProperty(String key, String value) {
        return this.delegate.setCommitProperty(key, value);
    }

    @Override
    public void setCommittables(Set<? extends EObject> committables) {
        this.delegate.setCommittables(committables);
    }

    @Override
    public Set<? extends EObject> getCommittables() {
        return this.delegate.getCommittables();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public CDOResourceNode[] getElements() {
        return (CDOResourceNode[])this.delegate.getElements();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    public static File createTempFile(CDOTransaction transaction) throws IOException {
        String prefix = "cdo_tx_" + transaction.getSession().getSessionID() + "_" + transaction.getViewID() + "__";
        return File.createTempFile(prefix, null);
    }
}

