/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.clipboard;

import java.util.Iterator;
import java.util.List;

public final class UriTransferData {
    private final List<String> uriStrings;
    static final String LINE_SEP = System.getProperty("line.separator");

    public UriTransferData(List<String> uriStrings) {
        this.uriStrings = uriStrings;
    }

    public List<String> getUriStrings() {
        return this.uriStrings;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uriStrings == null ? 0 : this.uriStrings.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UriTransferData other = (UriTransferData)obj;
        return !(this.uriStrings == null ? other.uriStrings != null : !this.uriStrings.equals(other.uriStrings));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.uriStrings != null && !this.uriStrings.isEmpty()) {
            s.append("\n");
            Iterator<String> iter = this.uriStrings.iterator();
            while (iter.hasNext()) {
                String uri = iter.next();
                s.append(uri);
                if (!iter.hasNext()) continue;
                s.append("\n");
            }
        }
        return s.toString();
    }
}

