/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.internal.WTPResourcesImages;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WTPResourcesNode
implements IWorkbenchAdapter {
    private static final int HASHCODE_ADDITION = 1284;
    private static final Logger LOG = LoggerFactory.getLogger(WTPResourcesNode.class);
    private final IProject project;

    public WTPResourcesNode(IProject project) {
        this.project = project;
    }

    public Object[] getResources() {
        Object[] folders = this.getRootFolders();
        if (folders != null && folders.length == 1) {
            try {
                return folders[0].members();
            }
            catch (CoreException ex) {
                LOG.error(Messages.WTPResourcesNode_Error_Getting_WTP_Resources, (Throwable)ex);
            }
        }
        return folders;
    }

    public String getLabel(Object o) {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
            if (facetedProject != null && facetedProject.hasProjectFacet(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET)) {
                return WTPResourcesImages.APP_RESOURCES;
            }
        }
        catch (CoreException ex) {
            LOG.error(Messages.WTPResourcesNode_Cant_Retrieve_Project_Facet, (Throwable)ex);
        }
        return WTPResourcesImages.WEB_RESOURCES;
    }

    public Object getParent(Object o) {
        return this.project;
    }

    public Object[] getChildren(Object o) {
        return this.getResources();
    }

    private IContainer[] getRootFolders() {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
        IContainer[] folders = null;
        if (component != null) {
            IVirtualFolder rootFolder = component.getRootFolder();
            folders = rootFolder.getUnderlyingFolders();
        } else {
            folders = new IContainer[]{};
        }
        return folders;
    }

    public String getLabel() {
        return Messages.WTPResourcesNode_Deployed_Resources_Label;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WTPResourcesNode)) {
            return false;
        }
        IProject p = ((WTPResourcesNode)o).project;
        return this.project == null ? p == null : this.project.equals((Object)p);
    }

    public int hashCode() {
        return 1284 + (this.project == null ? 0 : this.project.hashCode());
    }
}

