/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.kdm.source.extension.discovery;

import java.io.IOException;
import java.lang.constant.Constable;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.kdm.source.discoverer.DiscoverSourceModelFromJavaElement;
import org.eclipse.modisco.kdm.source.discoverer.DiscoverSourceModelFromResource;
import org.eclipse.modisco.kdm.source.extension.Activator;
import org.eclipse.modisco.kdm.source.extension.discovery.Messages;

public abstract class AbstractComposedKDMSourceDiscoverer2<T>
extends AbstractModelDiscoverer<T> {
    private static final int FLUSH_LIMIT_SHIFT = 16;
    private static final Integer FLUSH_LIMIT = 65536;
    private Resource kdmSourceModelResource = null;

    protected void setKdmSourceModelResource(Resource kdmSourceModelResource) {
        this.kdmSourceModelResource = kdmSourceModelResource;
    }

    protected Resource getKdmSourceModelResource() {
        return this.kdmSourceModelResource;
    }

    protected void basicDiscoverElement(T source, IProgressMonitor monitor) throws DiscoveryException {
        this.initializeCompositeModel(source, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        this.discoverOtherLeafModels(source, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        this.discoverKDMSourceModel(source, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        this.finishBuildingModel(source, monitor);
    }

    protected abstract void initializeCompositeModel(T var1, IProgressMonitor var2);

    protected abstract void discoverOtherLeafModels(T var1, IProgressMonitor var2);

    protected abstract void finishBuildingModel(T var1, IProgressMonitor var2);

    protected Resource discoverKDMSourceModel(T source, IProgressMonitor monitor) throws DiscoveryException {
        monitor.subTask(Messages.AbstractComposedKDMSourceDiscoverer_1);
        if (source instanceof IResource) {
            IResource resource = (IResource)source;
            DiscoverSourceModelFromResource discoverer = new DiscoverSourceModelFromResource();
            discoverer.setSerializeTarget(this.isSerializeKDMResource());
            discoverer.setTargetURI(this.getKDMResourceTargetURI());
            discoverer.discoverElement((Object)resource, monitor);
            if (discoverer.getTargetModel().getURI() == null) {
                discoverer.getTargetModel().setURI(discoverer.getDefaultTargetURI());
            }
            this.getResourceSet().getResources().add((Object)discoverer.getTargetModel());
            this.kdmSourceModelResource = discoverer.getTargetModel();
            return this.kdmSourceModelResource;
        }
        if (source instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)source;
            DiscoverSourceModelFromJavaElement discoverer = new DiscoverSourceModelFromJavaElement();
            discoverer.setSerializeTarget(this.isSerializeKDMResource());
            discoverer.setTargetURI(this.getKDMResourceTargetURI());
            discoverer.discoverElement((Object)javaElement, monitor);
            if (discoverer.getTargetModel().getURI() == null) {
                discoverer.getTargetModel().setURI(discoverer.getDefaultTargetURI());
            }
            this.getResourceSet().getResources().add((Object)discoverer.getTargetModel());
            this.kdmSourceModelResource = discoverer.getTargetModel();
            return this.kdmSourceModelResource;
        }
        throw new IllegalArgumentException("source type not handled: " + source.getClass().getName());
    }

    protected abstract boolean isSerializeKDMResource();

    protected abstract URI getKDMResourceTargetURI();

    protected static void saveResource(Resource resource) throws IOException {
        HashMap<String, Constable> options = new HashMap<String, Constable>();
        options.put("FLUSH_THRESHOLD", FLUSH_LIMIT);
        options.put("USE_FILE_BUFFER", Boolean.TRUE);
        if (resource.getURI() == null) {
            MoDiscoLogger.logError((String)"Cannot save a Resource without URI.", (Plugin)Activator.getDefault());
            return;
        }
        try {
            resource.save(options);
        }
        catch (Resource.IOWrappedException e) {
            if (e.getCause() != null && e.getCause() instanceof CoreException) {
                MoDiscoLogger.logWarning((Throwable)e, (String)("XMI serialization has failed on '" + String.valueOf(resource.getURI()) + "'. Trying again without File Buffer."), (Plugin)Activator.getDefault());
                options.clear();
                resource.save(options);
                MoDiscoLogger.logInfo((String)("XMI serialization is done for " + String.valueOf(resource.getURI())), (Plugin)Activator.getDefault());
            }
            throw e;
        }
    }
}

