/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceContainerTypeDelegate;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumSourceDirector;
import org.eclipse.wst.jsdt.chromium.debug.core.Messages;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ResourceManager;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResource;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceId;

public class VProjectSourceContainer
implements ISourceContainer {
    private static final String TYPE_ID = "org.eclipse.wst.jsdt.chromium.debug.core.VProjectSourceContainer.type";
    private ChromiumSourceDirector chromiumSourceDirector = null;

    VProjectSourceContainer() {
    }

    public void init(ISourceLookupDirector director) {
        if (director instanceof ChromiumSourceDirector) {
            this.chromiumSourceDirector = (ChromiumSourceDirector)director;
        }
    }

    public void dispose() {
    }

    public Object[] findSourceElements(String name) {
        if (this.chromiumSourceDirector == null) {
            return new Object[0];
        }
        ResourceManager resourceManager = this.chromiumSourceDirector.getResourceManager();
        LookupResult lookupResult = new LookupResult(resourceManager);
        return new Object[]{lookupResult};
    }

    public String getName() {
        IProject project = null;
        if (this.chromiumSourceDirector != null) {
            project = this.chromiumSourceDirector.getProject();
        }
        if (project == null) {
            return Messages.VProjectSourceContainer_DEFAULT_TYPE_NAME;
        }
        return project.getName();
    }

    public ISourceContainer[] getSourceContainers() {
        return null;
    }

    public ISourceContainerType getType() {
        return DebugPlugin.getDefault().getLaunchManager().getSourceContainerType(TYPE_ID);
    }

    public boolean isComposite() {
        return false;
    }

    public VmResourceId findScriptId(IFile resource) {
        if (this.chromiumSourceDirector == null) {
            throw new IllegalStateException();
        }
        return this.chromiumSourceDirector.getResourceManager().getResourceId(resource);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public static class LookupResult {
        private final ResourceManager resourceManager;

        LookupResult(ResourceManager resourceManager) {
            this.resourceManager = resourceManager;
        }

        public VmResource getVmResource(VmResourceId resourceId) {
            return this.resourceManager.getVmResource(resourceId);
        }
    }

    public static class TypeDelegate
    implements ISourceContainerTypeDelegate {
        public ISourceContainer createSourceContainer(String memento) throws CoreException {
            return new VProjectSourceContainer();
        }

        public String getMemento(ISourceContainer container) throws CoreException {
            return "VProjectSourceContainer.memento.stub";
        }
    }
}

