/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.viewers.MonitorLabelProvider;
import org.eclipse.wst.server.ui.internal.viewers.PortContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.PortLabelProvider;

public class MonitorDialog
extends Dialog {
    protected IServer server;
    protected ServerPort port;
    protected int monitorPort = -1;
    protected String[] portContentTypes;
    protected String[] contentTypes;
    protected boolean isEdit = false;
    protected boolean portChanged = false;
    protected Button ok;
    protected Table table;
    protected TableViewer tableViewer;
    protected boolean init;

    public MonitorDialog(Shell parentShell, IServer server) {
        super(parentShell);
        this.server = server;
    }

    public MonitorDialog(Shell parentShell, IServer server, ServerPort port, int monitorPort, String[] contentTypes) {
        this(parentShell, server);
        this.monitorPort = monitorPort;
        this.contentTypes = contentTypes;
        this.port = port;
        this.isEdit = true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.dialogMonitorTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.ok = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 64);
        label.setText(NLS.bind((String)Messages.dialogMonitorAddDescription, (Object[])new String[]{this.server.getName()}));
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        data.widthHint = 275;
        label.setLayoutData((Object)data);
        this.table = new Table(composite, 68356);
        data = new GridData(1808);
        data.heightHint = 100;
        data.horizontalSpan = 2;
        this.table.setLayoutData((Object)data);
        this.table.setLinesVisible(true);
        this.tableViewer = new TableViewer(this.table);
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        this.table.setHeaderVisible(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(12, 120, true));
        TableColumn col = new TableColumn(this.table, 0);
        col.setText(Messages.dialogMonitorColumnType);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(4, 40, true));
        col = new TableColumn(this.table, 0);
        col.setText(Messages.dialogMonitorColumnPort);
        this.tableViewer.setContentProvider((IContentProvider)new PortContentProvider(this.server));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PortLabelProvider(this.server));
        this.tableViewer.setInput((Object)"root");
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ServerPort port1 = (ServerPort)e1;
                ServerPort port2 = (ServerPort)e2;
                if (port1.getPort() == port2.getPort()) {
                    return 0;
                }
                if (port1.getPort() > port2.getPort()) {
                    return 1;
                }
                return -1;
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.dialogMonitorMonitorPort);
        final Text portText = new Text(composite, 2048);
        data = new GridData(768);
        data.widthHint = 150;
        portText.setLayoutData((Object)data);
        if (this.monitorPort >= 0) {
            portText.setText("" + this.monitorPort);
        }
        portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                block3: {
                    try {
                        MonitorDialog.this.monitorPort = Integer.parseInt(portText.getText());
                        if (MonitorDialog.this.ok != null) {
                            MonitorDialog.this.ok.setEnabled(true);
                        }
                    }
                    catch (Exception exception) {
                        MonitorDialog.this.monitorPort = -1;
                        if (MonitorDialog.this.ok == null) break block3;
                        MonitorDialog.this.ok.setEnabled(false);
                    }
                }
                MonitorDialog.this.portChanged = true;
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.dialogMonitorContentType);
        final Combo combo = new Combo(composite, 8);
        data = new GridData(768);
        data.widthHint = 150;
        combo.setLayoutData((Object)data);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int size = combo.getItemCount();
                int sel = combo.getSelectionIndex();
                MonitorDialog.this.contentTypes = sel == size - 1 ? MonitorDialog.this.portContentTypes : new String[]{MonitorDialog.this.portContentTypes[sel]};
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MonitorDialog.this.port = (ServerPort)MonitorDialog.this.getSelection(MonitorDialog.this.tableViewer.getSelection());
                if (MonitorDialog.this.port == null) {
                    return;
                }
                if (!MonitorDialog.this.portChanged) {
                    portText.setText("" + (MonitorDialog.this.port.getPort() + 1));
                    MonitorDialog.this.portChanged = false;
                }
                MonitorDialog.this.portContentTypes = MonitorDialog.this.port.getContentTypes();
                String[] s = null;
                String all = Messages.dialogMonitorContentTypeAll;
                if (MonitorDialog.this.portContentTypes == null || MonitorDialog.this.portContentTypes.length == 1) {
                    s = new String[]{all};
                } else {
                    int size = MonitorDialog.this.portContentTypes.length;
                    s = new String[size + 1];
                    int i = 0;
                    while (i < size) {
                        s[i] = MonitorLabelProvider.getContentTypeString(MonitorDialog.this.portContentTypes[i]);
                        ++i;
                    }
                    s[size] = all;
                }
                combo.setItems(s);
                combo.setText(all);
            }
        });
        Dialog.applyDialogFont((Control)composite);
        if (this.port != null) {
            this.portChanged = true;
            String[] ct = this.contentTypes;
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.port));
            if (ct != null && ct.length > 0) {
                combo.setText(MonitorLabelProvider.getContentTypeString(ct[0]));
            }
        } else if (this.tableViewer != null) {
            try {
                Object obj = this.tableViewer.getElementAt(0);
                if (obj != null) {
                    this.tableViewer.setSelection((ISelection)new StructuredSelection(obj));
                }
            }
            catch (Exception exception) {}
        }
        this.portChanged = false;
        return composite;
    }

    protected Object getSelection(ISelection sel2) {
        IStructuredSelection sel = (IStructuredSelection)sel2;
        return sel.getFirstElement();
    }

    public int getMonitorPort() {
        return this.monitorPort;
    }

    public ServerPort getServerPort() {
        return this.port;
    }

    public String[] getContentTypes() {
        return this.contentTypes;
    }
}

