/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class SimpleDependencyInfo
implements DependencyInfo {
    private final List<String> provides;
    private final List<String> requires;
    private final ImmutableMap<String, String> loadFlags;
    private final String srcPathRelativeToClosure;
    private final String pathOfDefiningFile;
    public static final SimpleDependencyInfo EMPTY = new SimpleDependencyInfo("", "", (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of());

    public SimpleDependencyInfo(String srcPathRelativeToClosure, String pathOfDefiningFile, List<String> provides, List<String> requires, boolean isModule) {
        this(srcPathRelativeToClosure, pathOfDefiningFile, provides, requires, SimpleDependencyInfo.loadFlags(isModule));
    }

    public SimpleDependencyInfo(String srcPathRelativeToClosure, String pathOfDefiningFile, List<String> provides, List<String> requires, Map<String, String> loadFlags) {
        this.srcPathRelativeToClosure = srcPathRelativeToClosure;
        this.pathOfDefiningFile = pathOfDefiningFile;
        this.provides = provides;
        this.requires = requires;
        this.loadFlags = ImmutableMap.copyOf(loadFlags);
    }

    @Override
    public String getName() {
        return this.pathOfDefiningFile;
    }

    @Override
    public String getPathRelativeToClosureBase() {
        return this.srcPathRelativeToClosure;
    }

    @Override
    public ImmutableMap<String, String> getLoadFlags() {
        return this.loadFlags;
    }

    private static Map<String, String> loadFlags(boolean isModule) {
        return isModule ? ImmutableMap.of((Object)"module", (Object)"goog") : ImmutableMap.of();
    }

    @Override
    public boolean isModule() {
        return "goog".equals(this.getLoadFlags().get((Object)"module"));
    }

    @Override
    public Collection<String> getProvides() {
        return Collections.unmodifiableList(this.provides);
    }

    @Override
    public Collection<String> getRequires() {
        return Collections.unmodifiableList(this.requires);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleDependencyInfo)) {
            return false;
        }
        SimpleDependencyInfo other = (SimpleDependencyInfo)obj;
        return Objects.equals(other.srcPathRelativeToClosure, this.srcPathRelativeToClosure) && Objects.equals(other.pathOfDefiningFile, this.pathOfDefiningFile) && Objects.equals(other.requires, this.requires) && Objects.equals(other.provides, this.provides) && Objects.equals(other.loadFlags, this.loadFlags);
    }

    public String toString() {
        return SimpleFormat.format("DependencyInfo(relativePath='%1$s', path='%2$s', provides=%3$s, requires=%4$s, loadFlags=%5$s)", this.srcPathRelativeToClosure, this.pathOfDefiningFile, this.provides, this.requires, this.loadFlags);
    }

    public int hashCode() {
        return Objects.hash(this.provides, this.requires, this.srcPathRelativeToClosure, this.pathOfDefiningFile, this.loadFlags);
    }
}

