/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.StaticTypedRef;
import com.google.javascript.rhino.jstype.StaticTypedSlot;

public class SimpleReference<T extends StaticTypedSlot<JSType>>
implements StaticTypedRef<JSType> {
    private final T symbol;
    private final Node node;

    public SimpleReference(T symbol, Node node) {
        this.symbol = symbol;
        this.node = node;
    }

    public final T getSymbol() {
        return this.symbol;
    }

    @Override
    public final Node getNode() {
        return this.node;
    }

    @Override
    public final StaticSourceFile getSourceFile() {
        return this.node.getStaticSourceFile();
    }

    public String toString() {
        String sourceName = this.node == null ? null : this.node.getSourceFileName();
        int lineNo = this.node == null ? -1 : this.node.getLineno();
        return this.node.getQualifiedName() + "@" + sourceName + ":" + lineNo;
    }
}

