/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.util.ReflectionUtils;

class ConstructorInvocation<T>
implements InvocationInterceptor.Invocation<T>,
ReflectiveInvocationContext<Constructor<T>> {
    private final Constructor<T> constructor;
    private final @Nullable Object[] arguments;

    ConstructorInvocation(Constructor<T> constructor, @Nullable Object[] arguments) {
        this.constructor = constructor;
        this.arguments = arguments;
    }

    public Class<?> getTargetClass() {
        return this.constructor.getDeclaringClass();
    }

    public Constructor<T> getExecutable() {
        return this.constructor;
    }

    public List<Object> getArguments() {
        return Collections.unmodifiableList(Arrays.asList(this.arguments));
    }

    public Optional<Object> getTarget() {
        return Optional.empty();
    }

    public T proceed() {
        return (T)ReflectionUtils.newInstance(this.constructor, (Object[])this.arguments);
    }
}

