/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view;

import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.IMulticoreVisualizerConstants;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerGraphicObject;
import org.eclipse.cdt.visualizer.ui.util.Colors;
import org.eclipse.cdt.visualizer.ui.util.GUIUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class MulticoreVisualizerLoadMeter
extends MulticoreVisualizerGraphicObject {
    protected boolean m_enabled = false;
    protected Integer m_currentLoad = null;
    protected Integer m_highLoadWatermark = null;
    protected Rectangle m_loadRect = null;
    protected Rectangle m_highWatermarkRect = null;
    protected Boolean m_showOnlyIfOverload = false;
    protected int m_overloadThreshold = 75;
    protected Color m_parentBgColor = null;

    public MulticoreVisualizerLoadMeter(Integer load) {
        this.m_currentLoad = load;
    }

    public MulticoreVisualizerLoadMeter(Integer load, Integer highWatermark) {
        this(load);
        this.m_highLoadWatermark = highWatermark;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public boolean getEnabled() {
        return this.m_enabled;
    }

    public void setLoad(Integer load) {
        this.m_currentLoad = load;
    }

    public int getLoad() {
        return this.m_currentLoad != null ? this.m_currentLoad : 0;
    }

    public boolean isLoadDefined() {
        return this.m_currentLoad != null;
    }

    public void setHighLoadWatermark(Integer wm) {
        this.m_highLoadWatermark = wm;
    }

    public void setOverloadThreshold(int t) {
        this.m_overloadThreshold = t;
    }

    public void setShowyOnlyIfOverload(Boolean o) {
        this.m_showOnlyIfOverload = o;
    }

    public void setParentBgColor(Color c) {
        this.m_parentBgColor = c;
    }

    private Color getLoadColor() {
        if (this.getLoad() < this.m_overloadThreshold) {
            return IMulticoreVisualizerConstants.COLOR_LOAD_LOADBAR_NORMAL;
        }
        return IMulticoreVisualizerConstants.COLOR_LOAD_LOADBAR_OVERLOAD;
    }

    @Override
    public void paintContent(GC gc) {
        if (!this.m_enabled) {
            return;
        }
        if (this.getLoad() < this.m_overloadThreshold && this.m_showOnlyIfOverload.booleanValue()) {
            return;
        }
        if (this.m_bounds.height < 30) {
            return;
        }
        if (this.m_parentBgColor == null) {
            this.m_parentBgColor = IMulticoreVisualizerConstants.COLOR_LOAD_UNDERBAR_BG_DEFAULT;
        }
        gc.setForeground(IMulticoreVisualizerConstants.COLOR_LOAD_UNDERBAR_FG);
        gc.setBackground(this.m_parentBgColor);
        gc.fillRectangle(this.m_bounds);
        gc.drawRectangle(this.m_bounds);
        int x = this.m_bounds.x;
        int y = (int)((float)this.m_bounds.y + (float)this.m_bounds.height * ((100.0f - (float)this.getLoad()) / 100.0f));
        int w = this.m_bounds.width;
        int h = (int)((float)this.m_bounds.height - (float)this.m_bounds.height * ((100.0f - (float)this.getLoad()) / 100.0f));
        this.m_loadRect = new Rectangle(x, y, w, h);
        gc.setBackground(this.getLoadColor());
        gc.fillRectangle(this.m_loadRect);
        gc.drawRectangle(this.m_loadRect);
        if (this.m_highLoadWatermark != null) {
            x = this.m_bounds.x - 5;
            y = (int)((float)this.m_bounds.y + (float)this.m_bounds.height * ((100.0f - (float)this.m_highLoadWatermark.intValue()) / 100.0f));
            w = this.m_bounds.width + 7;
            h = 2;
            this.m_highWatermarkRect = new Rectangle(x, y, w, h);
            gc.setBackground(Colors.BLACK);
            gc.setForeground(Colors.DARK_RED);
            gc.fillRectangle(this.m_highWatermarkRect);
            gc.drawRectangle(this.m_highWatermarkRect);
        }
    }

    public boolean hasDecorations() {
        return true;
    }

    public void paintDecorations(GC gc) {
        if (!this.m_enabled) {
            return;
        }
        if (this.getLoad() < this.m_overloadThreshold && this.m_showOnlyIfOverload.booleanValue()) {
            return;
        }
        String load = this.isLoadDefined() ? Integer.toString(this.getLoad()) : "n/a";
        if (this.m_bounds.height > 50) {
            gc.setForeground(IMulticoreVisualizerConstants.COLOR_LOAD_TEXT);
            int tx = this.m_bounds.x;
            int ty = this.m_bounds.y;
            GUIUtils.drawTextAligned((GC)gc, (String)load, (int)tx, (int)ty, (boolean)true, (boolean)false);
        }
    }
}

