/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.WithTableReference;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.dialogs.AddTableDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.model.DeleteHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.InsertHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.UpdateHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;

public class AddTableAction
extends Action {
    Object object;
    SQLDomainModel domainModel;
    Object selectTableToReplace = null;
    boolean replace = false;

    public AddTableAction(SQLDomainModel domainModel) {
        super(Messages._UI_ACTION_ADD_TABLE);
        this.domainModel = domainModel;
    }

    public void setTable(Object table) {
        this.selectTableToReplace = table;
        if (table != null) {
            this.replace = true;
            this.setText(Messages._UI_ACTION_ADD_TABLE_REPLACE);
        } else {
            this.replace = false;
            this.setText(Messages._UI_ACTION_ADD_TABLE);
        }
    }

    public void setElement(Object obj) {
        this.object = obj;
        if (this.selectTableToReplace == null) {
            this.replace = false;
            if (this.object instanceof QueryInsertStatement) {
                this.replace = ((QueryInsertStatement)this.object).getTargetTable() != null;
            } else if (this.object instanceof QueryUpdateStatement) {
                this.replace = ((QueryUpdateStatement)this.object).getTargetTable() != null;
            } else if (this.object instanceof QueryDeleteStatement) {
                boolean bl = this.replace = ((QueryDeleteStatement)this.object).getTargetTable() != null;
            }
            if (this.replace) {
                this.setText(Messages._UI_ACTION_ADD_TABLE_REPLACE);
            } else {
                this.setText(Messages._UI_ACTION_ADD_TABLE);
            }
        }
    }

    Shell getShell() {
        return SQLBuilderPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public void run() {
        SQLObject table2 = null;
        String tableAlias = null;
        if (this.object != null) {
            List tableList = new ArrayList();
            if (this.object instanceof SQLQueryObject) {
                tableList = StatementHelper.getTablesForStatement((SQLQueryObject)((SQLQueryObject)this.object));
            }
            Vector<String> tableNames = new Vector<String>();
            int i = 0;
            while (i < tableList.size()) {
                Object item = tableList.get(i);
                if (item instanceof TableExpression) {
                    TableExpression tableExpr = (TableExpression)item;
                    tableNames.addElement(tableExpr.getName());
                } else if (item instanceof Table) {
                    tableNames.addElement(((Table)item).getName());
                }
                ++i;
            }
        }
        Object action = null;
        action = this.replace ? AddTableDialog.REPLACE_TABLE : AddTableDialog.ADD_TABLE;
        AddTableDialog dialog = new AddTableDialog(this.getShell(), this.domainModel, this.object, null);
        dialog.setAction(action);
        String tableName = "";
        if (this.selectTableToReplace != null) {
            tableName = this.selectTableToReplace instanceof TableExpression ? ((TableExpression)this.selectTableToReplace).getName() : ((Table)this.selectTableToReplace).getName();
        }
        dialog.setReplaceTitle(tableName);
        dialog.create();
        dialog.setBlockOnOpen(true);
        int value = dialog.open();
        if (value == 1) {
            return;
        }
        List tableList = dialog.getTablesList();
        if (tableList != null && tableList.size() > 0) {
            table2 = (SQLObject)tableList.get(0);
        }
        tableAlias = dialog.getTableAlias();
        if (table2 != null) {
            if (this.object instanceof QuerySelectStatement || this.object instanceof QuerySelect) {
                SQLQueryObject stmt = (SQLQueryObject)this.object;
                String name = stmt.getName();
                String label = stmt.getLabel();
                TableInDatabase tableExpr = null;
                int replacePosition = 0;
                if (this.replace) {
                    if (this.selectTableToReplace instanceof Table) {
                        List tblExprList = StatementHelper.getTablesForStatement((SQLQueryObject)stmt);
                        TableExpression oldTableExpr = TableHelper.getTableExpressionFromTableExprList((String)((Table)this.selectTableToReplace).getName(), (List)tblExprList);
                        replacePosition = tblExprList.indexOf(oldTableExpr);
                        if (oldTableExpr != null) {
                            StatementHelper.removeTableExpressionFromQueryStatement((TableExpression)oldTableExpr, (SQLQueryObject)stmt);
                        }
                    } else if (this.selectTableToReplace instanceof WithTableReference) {
                        StatementHelper.removeTableExpressionFromQueryStatement((TableExpression)((WithTableReference)this.selectTableToReplace), (SQLQueryObject)stmt);
                    }
                }
                for (SQLObject table2 : tableList) {
                    if (table2 instanceof Table) {
                        tableExpr = TableHelper.createTableExpressionForTable((Table)((Table)table2));
                    } else if (table2 instanceof WithTableSpecification) {
                        tableExpr = StatementHelper.createWithTableReferenceForWithTable((WithTableSpecification)((WithTableSpecification)table2));
                    }
                    if (tableAlias.trim().length() > 0) {
                        TableHelper.setTableAliasInTableExpression((TableExpression)tableExpr, (String)tableAlias);
                    }
                    if (stmt instanceof QuerySelectStatement) {
                        if (this.replace) {
                            SelectHelper.addTableToStatementAtPosition(stmt, (TableExpression)tableExpr, replacePosition);
                            continue;
                        }
                        SelectHelper.addTableToStatement((QuerySelectStatement)stmt, (TableExpression)tableExpr);
                        continue;
                    }
                    if (!(stmt instanceof QuerySelect)) continue;
                    if (this.replace) {
                        SelectHelper.addTableToStatementAtPosition(stmt, (TableExpression)tableExpr, replacePosition);
                        continue;
                    }
                    SelectHelper.addTableToStatement((QuerySelect)stmt, (TableExpression)tableExpr);
                }
                stmt.setName(name);
                stmt.setLabel(label);
            } else if (this.object instanceof QueryInsertStatement) {
                QueryInsertStatement stmt = (QueryInsertStatement)this.object;
                String name = stmt.getName();
                String label = stmt.getLabel();
                TableInDatabase tableExpr = TableHelper.createTableExpressionForTable((Table)((Table)table2));
                InsertHelper.clearStatementContents(stmt);
                InsertHelper.setTargetTable(stmt, tableExpr);
                stmt.setName(name);
                stmt.setLabel(label);
            } else if (this.object instanceof QueryUpdateStatement) {
                QueryUpdateStatement stmt = (QueryUpdateStatement)this.object;
                String name = stmt.getName();
                String label = stmt.getLabel();
                TableInDatabase tableExpr = TableHelper.createTableExpressionForTable((Table)((Table)table2));
                if (tableAlias.trim().length() > 0) {
                    TableHelper.setTableAliasInTableExpression((TableExpression)tableExpr, (String)tableAlias);
                }
                UpdateHelper.clearStatementContents(stmt);
                UpdateHelper.setTargetTable(stmt, tableExpr);
                stmt.setName(name);
                stmt.setLabel(label);
            } else if (this.object instanceof QueryDeleteStatement) {
                QueryDeleteStatement stmt = (QueryDeleteStatement)this.object;
                String name = stmt.getName();
                String label = stmt.getLabel();
                TableInDatabase tableExpr = TableHelper.createTableExpressionForTable((Table)((Table)table2));
                if (tableAlias.trim().length() > 0) {
                    TableHelper.setTableAliasInTableExpression((TableExpression)tableExpr, (String)tableAlias);
                }
                DeleteHelper.clearStatementContents(stmt);
                DeleteHelper.setTargetTable(stmt, tableExpr);
                stmt.setName(name);
                stmt.setLabel(label);
            }
        }
    }
}

