/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IPathEditorInput;

public class ResourceExtender
extends PropertyTester {
    private static final String PROPERTY_MATCHES_PATTERN = "matchesPattern";
    private static final String PROJECT_NATURE = "projectNature";
    private static final String PROPERTY_MATCHES_CONTENT_TYPE = "matchesContentType";

    public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
        IResource resource = (IResource)((IAdaptable)receiver).getAdapter(IResource.class);
        if (resource == null) {
            IPath path;
            File file;
            IPathEditorInput editorInput;
            if (PROPERTY_MATCHES_CONTENT_TYPE.equals(method) && (editorInput = (IPathEditorInput)((IAdaptable)receiver).getAdapter(IPathEditorInput.class)) != null && (file = (path = editorInput.getPath()).toFile()).exists()) {
                try {
                    Throwable throwable = null;
                    Object var10_19 = null;
                    try (FileReader reader = new FileReader(file);){
                        IContentType contentType = Platform.getContentTypeManager().getContentType((String)expectedValue);
                        IContentDescription description = contentType.getDescriptionFor((Reader)reader, IContentDescription.ALL);
                        if (description != null) {
                            return this.matchesContentType(description.getContentType(), (String)expectedValue);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (FileNotFoundException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
        } else {
            if (PROPERTY_MATCHES_PATTERN.equals(method)) {
                String fileName = resource.getName();
                String expected = (String)expectedValue;
                expected = expected.replaceAll("\\.", "\\\\.");
                expected = expected.replaceAll("\\*", "\\.\\*");
                Pattern pattern = Pattern.compile(expected);
                boolean retVal = pattern.matcher(fileName).find();
                return retVal;
            }
            if (PROJECT_NATURE.equals(method)) {
                try {
                    IProject proj = resource.getProject();
                    return proj != null && proj.isAccessible() && proj.hasNature((String)expectedValue);
                }
                catch (CoreException e) {
                    return false;
                }
            }
            if (PROPERTY_MATCHES_CONTENT_TYPE.equals(method)) {
                return this.matchesContentType(resource, (String)expectedValue);
            }
        }
        return false;
    }

    private boolean matchesContentType(IContentType type, String typeId) {
        while (type != null) {
            if (typeId.equals(type.getId())) {
                return true;
            }
            type = type.getBaseType();
        }
        return false;
    }

    private boolean matchesContentType(IResource resource, String contentType) {
        IContentDescription description;
        IFile file;
        block7: {
            block6: {
                if (resource == null || !(resource instanceof IFile)) break block6;
                file = (IFile)resource;
                if (resource.exists()) break block7;
            }
            return false;
        }
        try {
            description = file.getContentDescription();
        }
        catch (CoreException e) {
            return false;
        }
        if (description != null) {
            return this.matchesContentType(description.getContentType(), contentType);
        }
        return false;
    }
}

