/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.eresource.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.eresource.CDOResourceFactory;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.collection.CollectionUtil;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class CDOResourceFactoryImpl
implements CDOResourceFactory {
    public static final CDOResourceFactory INSTANCE = new CDOResourceFactoryImpl();
    private static final Set<String> RESOURCE_SET_CLASS_NAMES = CDOResourceFactoryImpl.initResourceSetClassNames();

    public Set<String> getResourceSetClassNames() {
        return RESOURCE_SET_CLASS_NAMES;
    }

    public Resource createResource(URI uri) {
        CDOResourceImpl resource = this.createCDOResource(uri);
        boolean existing = this.isGetResource();
        resource.setExisting(existing);
        return resource;
    }

    protected CDOResourceImpl createCDOResource(URI uri) {
        return new CDOResourceImpl(uri);
    }

    protected boolean isGetResource() {
        boolean inResourceSet = false;
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        int i = 3;
        while (i < elements.length) {
            StackTraceElement element = elements[i];
            if (RESOURCE_SET_CLASS_NAMES.contains(element.getClassName())) {
                inResourceSet = true;
            } else if (inResourceSet) break;
            if (inResourceSet && "getResource".equals(element.getMethodName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Set<String> initResourceSetClassNames() {
        HashSet<String> set = new HashSet<String>();
        set.add(ResourceSetImpl.class.getName());
        set.add("org.eclipse.xtext.resource.XtextResourceSet");
        set.add("org.eclipse.xtext.resource.ResourceSetReferencingResourceSetImpl");
        set.add("org.eclipse.xtext.resource.SynchronizedXtextResourceSet");
        ResourceSetClassNameProvider.Factory.fillClassNames(set);
        return set;
    }

    public static interface ResourceSetClassNameProvider {
        public String[] getResourceSetClassNames();

        public static abstract class Factory
        extends org.eclipse.net4j.util.factory.Factory {
            public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.resourceSetClassNameProviders";

            public Factory(String type) {
                super(PRODUCT_GROUP, type);
            }

            public abstract ResourceSetClassNameProvider create(String var1) throws ProductCreationException;

            private static void fillClassNames(Set<String> classNames) {
                for (String type : IPluginContainer.INSTANCE.getFactoryTypes(PRODUCT_GROUP)) {
                    ResourceSetClassNameProvider provider = (ResourceSetClassNameProvider)IPluginContainer.INSTANCE.getElementOrNull(PRODUCT_GROUP, type);
                    if (provider == null) continue;
                    try {
                        String[] stringArray = provider.getResourceSetClassNames();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String className = stringArray[n2];
                            CollectionUtil.addNotNull(classNames, (Object)className);
                            ++n2;
                        }
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                }
            }
        }
    }
}

