/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.analyzer;

import java.util.Objects;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class CDOFetchFeatureInfo {
    private static final long INITIAL_TIME_BEFORE_USED = 0L;
    private static final long INITIAL_LATENCY_TIME = -1L;
    private final EClass eClass;
    private final EStructuralFeature feature;
    private long timeBeforeUsed = 0L;
    private long latencyTime = -1L;
    private boolean active;

    public CDOFetchFeatureInfo(EClass eClass, EStructuralFeature feature) {
        this.eClass = eClass;
        this.feature = feature;
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public EStructuralFeature getEStructuralFeature() {
        return this.feature;
    }

    public long getTimeBeforeUsed() {
        return this.timeBeforeUsed;
    }

    public long getLatencyTime() {
        return this.latencyTime;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void updateTimeInfo(long elapseTimeBeforeLastRequest) {
        long oldTimeBeforeUsed = this.timeBeforeUsed;
        this.timeBeforeUsed = oldTimeBeforeUsed == 0L ? elapseTimeBeforeLastRequest : (oldTimeBeforeUsed + elapseTimeBeforeLastRequest) / 2L;
    }

    public void updateLatencyTime(long latencyTime) {
        long oldLatencyTime = this.latencyTime;
        this.latencyTime = oldLatencyTime == -1L ? latencyTime : (latencyTime + oldLatencyTime) / 2L;
    }

    public int hashCode() {
        return Objects.hash(this.eClass, this.feature);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDOFetchFeatureInfo) {
            CDOFetchFeatureInfo featureInfo = (CDOFetchFeatureInfo)obj;
            return featureInfo.eClass == this.eClass && featureInfo.feature == this.feature;
        }
        return false;
    }
}

