/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.action;

import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.action.AbstractPreDefinedAction;
import org.eclipse.graphiti.ui.internal.action.IContextAndFeatureProvider;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.ui.IWorkbenchPart;

public class UpdateAction
extends AbstractPreDefinedAction
implements IContextAndFeatureProvider {
    public static final String TOOL_TIP = Messages.UpdateAction_0_xmsg;
    public static final String TEXT = Messages.UpdateAction_1_xfld;
    public static final String ACTION_ID = "predefined update action";
    public static final String ACTION_DEFINITION_ID = "org.eclipse.graphiti.ui.internal.action.UpdateAction";

    public UpdateAction(IWorkbenchPart part, IConfigurationProvider configurationProvider) {
        super(part, configurationProvider);
        this.setId(ACTION_ID);
        this.setText(TEXT);
        this.setToolTipText(TOOL_TIP);
        this.setActionDefinitionId(ACTION_DEFINITION_ID);
        this.setLazyEnablementCalculation(true);
    }

    @Override
    public boolean isAvailable() {
        PictogramElement[] pe = this.getSelectedPictogramElements();
        int i = 0;
        while (i < pe.length) {
            UpdateContext context = new UpdateContext(pe[i]);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
            if (updateFeature == null || !updateFeature.isAvailable((IContext)context)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean calculateEnabled() {
        PictogramElement[] pe = this.getSelectedPictogramElements();
        int i = 0;
        while (i < pe.length) {
            IUpdateFeature updateFeature;
            UpdateContext context = new UpdateContext(pe[i]);
            IFeatureProvider featureProvider = this.getFeatureProvider();
            if (featureProvider != null && (updateFeature = featureProvider.getUpdateFeature((IUpdateContext)context)) != null && updateFeature.isAvailable((IContext)context) && updateFeature.canExecute((IContext)context)) {
                if (pe.length == 1 && pe[0] instanceof Diagram) {
                    return true;
                }
                if (updateFeature.updateNeeded((IUpdateContext)context).toBoolean()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void run() {
        this.genericRun(this);
    }

    @Override
    public IContext createContext(PictogramElement pe) {
        return new UpdateContext(pe);
    }

    @Override
    public IFeature provideFeatureForContext(IContext context) {
        return this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
    }
}

