/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.core.internal.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.util.logger.proxyrender.DefaultPluginTraceRenderer;
import org.eclipse.jst.j2ee.core.internal.plugin.CatalogJ2EEXmlDtDEntityResolver;
import org.eclipse.jst.j2ee.core.internal.plugin.EclipseEJBModelExtenderProvider;
import org.eclipse.jst.j2ee.internal.IEJBModelExtenderManager;
import org.eclipse.jst.j2ee.internal.xml.J2EEXmlDtDEntityResolver;
import org.eclipse.wst.common.internal.emf.utilities.DOMUtilities;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.xml.sax.EntityResolver;

public class J2EECorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.jst.j2ee.core";
    private static J2EECorePlugin inst = null;
    protected static Logger logger = null;

    public J2EECorePlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IEJBModelExtenderManager.INSTANCE.setProvider(EclipseEJBModelExtenderProvider.getInstance());
        J2EEXmlDtDEntityResolver.INSTANCE = new CatalogJ2EEXmlDtDEntityResolver();
        DOMUtilities.setDefaultEntityResolver((EntityResolver)J2EEXmlDtDEntityResolver.INSTANCE);
    }

    public static J2EECorePlugin getPlugin() {
        return inst;
    }

    public static String getPluginID() {
        return PLUGIN_ID;
    }

    public Logger getMsgLogger() {
        if (logger == null) {
            logger = Logger.getLogger((String)J2EECorePlugin.getPluginID());
            this.setRenderer(logger);
        }
        return logger;
    }

    protected void setRenderer(Logger aLogger) {
        new DefaultPluginTraceRenderer(aLogger);
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return J2EECorePlugin.createStatus(severity, message, null);
    }

    public static void logError(Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(J2EECorePlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(exception.getStatus());
    }
}

