/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.NewProjectData;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.ProjectIntegrationHelper;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.SourceContainerUpdater;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewProjectCreationOperation
extends WorkspaceModifyOperation {
    private NewProjectData fData;
    private IProject fProjectHandle;

    public NewProjectCreationOperation(IProject projectHandle, NewProjectData projectData) {
        if (projectHandle == null || projectData == null) {
            throw new IllegalArgumentException();
        }
        this.fData = projectData;
        this.fProjectHandle = projectHandle;
    }

    protected void createContents(IProgressMonitor monitor, IProject project) throws CoreException, InterruptedException {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewQVTProjectWizard_Create, (int)2);
            IFolder srcContainer = project.getFolder(this.fData.getQVTSourceFolderName());
            if (srcContainer instanceof IFolder) {
                SourceContainerUpdater.ensureDestinationExists(srcContainer, (IProgressMonitor)subMonitor.split(1));
            }
            QVTOBuilderConfig qvtConfig = QVTOBuilderConfig.getConfig((IProject)project);
            qvtConfig.setSourceContainer((IContainer)srcContainer);
            qvtConfig.addTransformationNature();
            subMonitor.worked(1);
        }
        finally {
            SubMonitor.done((IProgressMonitor)monitor);
        }
    }

    public void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewProjectCreationOperation_createQVTProjectTask, (int)2);
        try {
            this.createProject((IProgressMonitor)subMonitor.split(1));
            this.createContents((IProgressMonitor)subMonitor.split(1), this.fProjectHandle);
        }
        finally {
            SubMonitor.done((IProgressMonitor)monitor);
        }
    }

    private void createProject(IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            URI location = URIUtil.toURI((IPath)this.fData.getLocation());
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProjectDescription description = workspace.newProjectDescription(this.fProjectHandle.getName());
            if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(location)) {
                location = null;
            }
            description.setLocationURI(location);
            if (!this.fProjectHandle.exists()) {
                this.fProjectHandle.create(description, (IProgressMonitor)subMonitor.split(1));
            }
            subMonitor.setWorkRemaining(2);
            this.fProjectHandle.open(128, (IProgressMonitor)subMonitor.split(1));
            ProjectIntegrationHelper.setupProject(this.fProjectHandle, this.fData, (IProgressMonitor)subMonitor.split(1));
        }
        finally {
            SubMonitor.done((IProgressMonitor)monitor);
        }
    }
}

