/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.options;

import org.eclipse.ocl.common.preferences.PreferenceableOption;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Option;

public enum ProblemOption implements PreferenceableOption<ProblemHandler.Severity>,
Option<ProblemHandler.Severity>
{
    CLOSURE_ITERATOR("org.eclipse.ocl", "iterators.closure", ProblemHandler.Severity.OK),
    STRING_CASE_CONVERSION("org.eclipse.ocl", "string.caseconv", ProblemHandler.Severity.WARNING),
    STRING_SINGLE_QUOTE_ESCAPE("org.eclipse.ocl", "string.escapes.squote", ProblemHandler.Severity.WARNING),
    ELEMENT_NAME_QUOTE_ESCAPE("org.eclipse.ocl", "string.escapes.element", ProblemHandler.Severity.WARNING),
    AMBIGUOUS_ASSOCIATION_ENDS("org.eclipse.ocl", "ambiguous.association.ends", ProblemHandler.Severity.ERROR),
    INHERITED_FEATURE_CONTEXT("org.eclipse.ocl", "inherited.feature.context", ProblemHandler.Severity.WARNING),
    CONCEPTUAL_OPERATION_NAME("org.eclipse.ocl", "conceptual.operation.name", ProblemHandler.Severity.ERROR);

    private final String pluginId;
    private final String key;
    private final ProblemHandler.Severity defaultValue;

    private ProblemOption(String key, ProblemHandler.Severity defaultValue) {
        this(null, key, defaultValue);
    }

    private ProblemOption(String pluginId, String key, ProblemHandler.Severity defaultValue) {
        this.pluginId = pluginId;
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public ProblemHandler.Severity getDefaultValue() {
        return this.defaultValue;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public ProblemHandler.Severity getValueOf(String string) {
        if (string != null) {
            try {
                return ProblemHandler.Severity.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.defaultValue;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.key)) + "[" + String.valueOf((Object)this.defaultValue) + "]";
    }
}

