/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.parts.composer;

import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.ui.controller.PackageController;
import org.eclipse.php.composer.ui.utils.WidgetFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PackageSearchPart {
    protected String name;
    protected FormToolkit toolkit;
    protected Composite body;
    protected Button checkbox;
    protected ComposerPackage composerPackage;

    public PackageSearchPart(Composite parent, ComposerPackage composerPackage, FormToolkit toolkit, String name) {
        this.toolkit = toolkit;
        this.name = name;
        this.composerPackage = composerPackage;
        this.create(parent, new WidgetFactory(toolkit));
    }

    protected void create(Composite parent, WidgetFactory factory) {
        this.createBody(parent, factory);
        this.createPackageCheckbox(this.body, factory, this.name);
    }

    protected Composite createBody(Composite parent, WidgetFactory factory) {
        this.body = factory.createComposite(parent, 2048);
        this.body.setLayout((Layout)new GridLayout());
        this.body.setLayoutData((Object)new GridData(4, 4, true, false));
        this.body.setBackground(this.getBackgroundColor());
        return this.body;
    }

    protected Button createPackageCheckbox(Composite parent, WidgetFactory factory, String name) {
        this.checkbox = new Button(parent, 32);
        this.checkbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.checkbox.setSelection(true);
        this.checkbox.setImage(PackageController.getPackageImage(name));
        this.checkbox.setText(PackageController.getPackageName(name));
        return this.checkbox;
    }

    protected Color getBackgroundColor() {
        if (this.toolkit != null) {
            return this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        }
        return Display.getCurrent().getSystemColor(25);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkbox.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkbox.removeSelectionListener(listener);
    }

    public String getName() {
        return this.name;
    }

    public boolean isChecked() {
        return this.checkbox.getSelection();
    }

    public void dispose() {
        this.body.dispose();
    }
}

